/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.interactive;

import kala.collection.MapLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import org.aya.cli.utils.RepoLike;
import org.aya.concrete.stmt.Stmt;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleExport;
import org.aya.resolve.context.ModuleName;
import org.aya.resolve.context.ModulePath;
import org.aya.resolve.context.ModuleSymbol;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplContext
extends PhysicalModuleContext
implements RepoLike<ReplContext> {
    @Nullable
    private ReplContext downstream = null;

    public ReplContext(@NotNull Context parent, @NotNull ModulePath name) {
        super(parent, name);
    }

    public void importSymbol(boolean imported, @NotNull AnyVar ref, @NotNull ModuleName modName, @NotNull String name, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Stmt.Accessibility acc, @NotNull SourcePos sourcePos) {
        this.symbols().add(modName, name, (Object)ref);
        if (ref instanceof DefVar) {
            DefVar defVar = (DefVar)ref;
            if (acc == Stmt.Accessibility.Public) {
                this.exportSymbol(modName, name, defVar);
            }
        }
    }

    public boolean exportSymbol(@NotNull ModuleName modName, @NotNull String name, @NotNull DefVar<?, ?> ref) {
        super.exportSymbol(modName, name, ref);
        return true;
    }

    public void importModule(@NotNull ModuleName.Qualified modName, @NotNull ModuleExport mod, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos) {
        this.modules.put((Object)modName, (Object)mod);
        if (accessibility == Stmt.Accessibility.Public) {
            this.exports.export(modName, mod);
        }
    }

    @NotNull
    public ReplContext derive(@NotNull @NotNull ImmutableSeq<@NotNull String> extraName) {
        return new ReplContext((Context)this, this.modulePath().derive(extraName));
    }

    @NotNull
    public ReplContext derive(@NotNull String extraName) {
        return new ReplContext((Context)this, this.modulePath().derive(new String[]{extraName}));
    }

    @Override
    public void setDownstream(@Nullable ReplContext downstream) {
        this.downstream = downstream;
    }

    @NotNull
    public ReplContext fork() {
        ReplContext kid = this.derive(":theKid");
        this.fork(kid);
        return kid;
    }

    @Override
    public void merge() {
        ReplContext bors = this.downstream;
        RepoLike.super.merge();
        if (bors == null) {
            return;
        }
        ReplContext.mergeSymbols(this.symbols, bors.symbols);
        ReplContext.mergeSymbols(this.exports.symbols(), bors.exports.symbols());
        this.exports.modules().putAll((MapLike)bors.exports.modules());
        this.modules.putAll((MapLike)bors.modules);
    }

    @Contract(mutates="this")
    public void clear() {
        this.modules.clear();
        this.exports.symbols().table().clear();
        this.exports.modules().clear();
        this.symbols.table().clear();
    }

    private static <T> void mergeSymbols(@NotNull ModuleSymbol<T> lhs, @NotNull ModuleSymbol<T> rhs) {
        rhs.table().forEach((uname, candy) -> ((MutableMap)lhs.resolveUnqualified(uname).asMut().get()).putAll((MapLike)candy));
    }
}

