/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.interactive;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kala.control.Option;
import org.aya.cli.utils.LiteratePrettierOptions;
import org.aya.generic.util.AyaHome;
import org.aya.generic.util.NormalizeMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class ReplConfig
implements AutoCloseable {
    public final transient Option<Path> configFile;
    @NotNull
    public String prompt = "> ";
    @NotNull
    public NormalizeMode normalizeMode = NormalizeMode.NF;
    @NotNull
    public LiteratePrettierOptions literatePrettier = new LiteratePrettierOptions();
    public boolean enableUnicode = true;
    public boolean silent = false;

    public ReplConfig(@NotNull Option<Path> file) {
        this.configFile = file;
    }

    @NotNull
    public static ReplConfig loadFromDefault() throws IOException, JsonParseException {
        return ReplConfig.loadFrom(AyaHome.ayaHome().resolve("repl_config.json"));
    }

    @NotNull
    public static ReplConfig loadFrom(@NotNull Path file) throws IOException, JsonParseException {
        if (Files.notExists(file, new LinkOption[0])) {
            return new ReplConfig((Option<Path>)Option.some((Object)file));
        }
        return ReplConfig.loadFrom((Option<Path>)Option.some((Object)file), Files.readString(file));
    }

    @VisibleForTesting
    @NotNull
    public static ReplConfig loadFrom(@NotNull Option<Path> file, @NotNull String jsonText) throws JsonParseException {
        ReplConfig config = (ReplConfig)LiteratePrettierOptions.gsonBuilder(new GsonBuilder()).registerTypeAdapter(ReplConfig.class, type -> new ReplConfig(file)).create().fromJson(jsonText, ReplConfig.class);
        if (config == null) {
            return new ReplConfig(file);
        }
        config.literatePrettier.checkDeserialization();
        return config;
    }

    @Override
    public void close() throws IOException {
        if (this.configFile.isDefined()) {
            Gson gson = LiteratePrettierOptions.gsonBuilder(new GsonBuilder()).create();
            Files.writeString((Path)this.configFile.get(), (CharSequence)gson.toJson((Object)this), new OpenOption[0]);
        }
    }
}

