/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.utils;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kala.collection.immutable.ImmutableSeq;
import kala.function.CheckedRunnable;
import org.aya.cli.single.CompilerFlags;
import org.aya.core.def.GenericDef;
import org.aya.core.serde.CompiledAya;
import org.aya.core.serde.Serializer;
import org.aya.generic.util.InternalException;
import org.aya.generic.util.InterruptException;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.module.FileModuleLoader;
import org.aya.util.reporter.CountingReporter;
import org.jetbrains.annotations.NotNull;

public class CompilerUtil {
    public static int catching(@NotNull CountingReporter reporter, @NotNull CompilerFlags flags, @NotNull CheckedRunnable<IOException> block) throws IOException {
        block4: {
            try {
                block.runChecked();
            }
            catch (InternalException e) {
                FileModuleLoader.handleInternalError((InternalException)e);
                reporter.reportString("Internal error");
                return e.exitCode();
            }
            catch (InterruptException e) {
                reporter.reportString(e.stage().name() + " interrupted due to:");
                if (!flags.interruptedTrace()) break block4;
                e.printStackTrace();
            }
        }
        if (reporter.noError()) {
            reporter.reportString(flags.message().successNotion());
            return 0;
        }
        reporter.reportString(reporter.countToString());
        reporter.reportString(flags.message().failNotion());
        return 1;
    }

    public static void saveCompiledCore(@NotNull Path coreFile, @NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<GenericDef> defs, @NotNull Serializer.State state) throws IOException {
        CompiledAya compiledAya = CompiledAya.from((ResolveInfo)resolveInfo, defs, (Serializer.State)state);
        try (ObjectOutputStream outputStream = CompilerUtil.coreWriter(coreFile);){
            outputStream.writeObject(compiledAya);
        }
    }

    @NotNull
    private static ObjectOutputStream coreWriter(@NotNull Path coreFile) throws IOException {
        Files.createDirectories(coreFile.toAbsolutePath().getParent(), new FileAttribute[0]);
        return new ObjectOutputStream(Files.newOutputStream(coreFile, new OpenOption[0]));
    }
}

