/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.single;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Function;
import kala.collection.immutable.ImmutableSeq;
import kala.function.CheckedRunnable;
import org.aya.cli.parse.AyaParserImpl;
import org.aya.cli.single.CompilerFlags;
import org.aya.cli.single.SingleAyaFile;
import org.aya.cli.utils.CliEnums;
import org.aya.cli.utils.CompilerUtil;
import org.aya.concrete.GenericAyaFile;
import org.aya.concrete.GenericAyaParser;
import org.aya.core.def.PrimDef;
import org.aya.generic.AyaDocile;
import org.aya.resolve.ModuleCallback;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.module.CachedModuleLoader;
import org.aya.resolve.module.FileModuleLoader;
import org.aya.resolve.module.ModuleListLoader;
import org.aya.resolve.module.ModuleLoader;
import org.aya.tyck.trace.Trace;
import org.aya.util.error.SourceFileLocator;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SingleFileCompiler(@NotNull Reporter reporter, @Nullable SourceFileLocator locator, @Nullable Trace.Builder builder) {
    public <E extends IOException> int compile(@NotNull Path sourceFile, @NotNull CompilerFlags flags, @Nullable ModuleCallback<E> moduleCallback) throws IOException {
        return this.compile(sourceFile, reporter -> new EmptyContext(reporter, sourceFile).derive(ImmutableSeq.of((Object)"Mian")), flags, moduleCallback);
    }

    public <E extends IOException> int compile(@NotNull Path sourceFile, @NotNull Function<Reporter, ModuleContext> context, @NotNull CompilerFlags flags, @Nullable ModuleCallback<E> moduleCallback) throws IOException {
        CountingReporter reporter = CountingReporter.of((Reporter)this.reporter);
        SourceFileLocator locator = this.locator != null ? this.locator : new SourceFileLocator.Module(flags.modulePaths());
        return CompilerUtil.catching(reporter, flags, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {
            ModuleContext ctx = (ModuleContext)context.apply((Reporter)reporter);
            AyaParserImpl ayaParser = new AyaParserImpl((Reporter)reporter);
            SingleAyaFile.Factory fileManager = new SingleAyaFile.Factory((Reporter)reporter);
            PrimDef.Factory primFactory = new PrimDef.Factory();
            SingleAyaFile ayaFile = fileManager.createAyaFile(locator, sourceFile);
            ImmutableSeq program = ayaFile.parseMe(ayaParser);
            ayaFile.pretty(flags, (ImmutableSeq<? extends AyaDocile>)program, CliEnums.PrettyStage.raw);
            CachedModuleLoader loader = new CachedModuleLoader((ModuleLoader)new ModuleListLoader((Reporter)reporter, flags.modulePaths().view().map(path -> new FileModuleLoader(locator, path, (Reporter)reporter, (GenericAyaParser)ayaParser, (GenericAyaFile.Factory)fileManager, primFactory, this.builder)).toImmutableSeq()));
            loader.tyckModule(primFactory, ctx, program, this.builder, (moduleResolve, defs) -> {
                ayaFile.tyckAdditional(moduleResolve);
                ayaFile.pretty(flags, (ImmutableSeq<? extends AyaDocile>)program, CliEnums.PrettyStage.scoped);
                ayaFile.pretty(flags, (ImmutableSeq<? extends AyaDocile>)defs, CliEnums.PrettyStage.typed);
                ayaFile.pretty(flags, (ImmutableSeq<? extends AyaDocile>)program, CliEnums.PrettyStage.literate);
                if (moduleCallback != null) {
                    moduleCallback.onModuleTycked(moduleResolve, defs);
                }
            });
        }));
    }
}

