/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.single;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.BiFunction;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import org.aya.cli.literate.AyaMdParser;
import org.aya.cli.literate.HighlightInfo;
import org.aya.cli.literate.HighlightsCollector;
import org.aya.cli.literate.SyntaxHighlight;
import org.aya.cli.render.RenderOptions;
import org.aya.cli.single.CompilerFlags;
import org.aya.cli.utils.CliEnums;
import org.aya.concrete.GenericAyaFile;
import org.aya.concrete.GenericAyaParser;
import org.aya.concrete.desugar.Desugarer;
import org.aya.concrete.remark.Literate;
import org.aya.concrete.remark.LiterateConsumer;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.core.def.Def;
import org.aya.core.def.PrimDef;
import org.aya.generic.AyaDocile;
import org.aya.generic.util.AyaFiles;
import org.aya.pretty.doc.Doc;
import org.aya.resolve.ResolveInfo;
import org.aya.tyck.ExprTycker;
import org.aya.util.FileUtil;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourceFileLocator;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SingleAyaFile
extends GenericAyaFile {
    @Nullable
    private static CompilerFlags.PrettyInfo parsePrettyInfo(@NotNull CompilerFlags flags) {
        if (flags.prettyInfo() != null) {
            return flags.prettyInfo();
        }
        return CompilerFlags.prettyInfoFromOutput(flags.outputFile(), new RenderOptions(), false, false, false);
    }

    default public void pretty(@NotNull CompilerFlags compilerFlags, @NotNull ImmutableSeq<? extends AyaDocile> doc, @NotNull CliEnums.PrettyStage currentStage) throws IOException {
        Object fileName;
        Path prettyDir;
        CompilerFlags.PrettyInfo flags = SingleAyaFile.parsePrettyInfo(compilerFlags);
        if (flags == null || currentStage != flags.prettyStage()) {
            return;
        }
        RenderOptions.OutputTarget out = flags.prettyFormat().target;
        if (compilerFlags.outputFile() != null) {
            prettyDir = compilerFlags.outputFile().toAbsolutePath().getParent();
            fileName = compilerFlags.outputFile().getFileName().toString();
        } else {
            prettyDir = flags.prettyDir() != null ? Path.of(flags.prettyDir(), new String[0]) : Path.of(".", new String[0]);
            fileName = AyaFiles.stripAyaSourcePostfix((String)this.originalFile().display()) + out.fileExt;
        }
        RenderOptions renderOptions = flags.renderOptions();
        if (currentStage == CliEnums.PrettyStage.literate) {
            Doc d2 = this.toDoc(doc, flags.prettierOptions());
            String text = renderOptions.render(out, d2, flags.renderOpts(true));
            FileUtil.writeString((Path)prettyDir.resolve((String)fileName), (String)text);
        } else {
            this.doWrite(doc, prettyDir, flags.prettierOptions(), (String)fileName, out.fileExt, (d, hdr) -> renderOptions.render(out, (Doc)d, flags.renderOpts((boolean)hdr)));
        }
    }

    @VisibleForTesting
    @NotNull
    default public Doc toDoc(@NotNull ImmutableSeq<Stmt> program, @NotNull PrettierOptions options) throws IOException {
        ImmutableSeq<HighlightInfo> highlights = SyntaxHighlight.highlight((Option<SourceFile>)Option.some((Object)this.codeFile()), program);
        Literate literate = this.literate();
        new HighlightsCollector(highlights, options).accept(literate);
        return literate.toDoc();
    }

    private void doWrite(ImmutableSeq<? extends AyaDocile> doc, Path prettyDir, @NotNull PrettierOptions options, String fileName, String fileExt, BiFunction<Doc, Boolean, String> toString) throws IOException {
        MutableList docs = MutableList.create();
        Path eachPrettyDir = prettyDir.resolve(fileName + ".each");
        for (int i = 0; i < doc.size(); ++i) {
            AyaDocile item = (AyaDocile)doc.get(i);
            Doc thisDoc = item.toDoc(options);
            docs.append((Object)thisDoc);
            if (item instanceof PrimDef) continue;
            FileUtil.writeString((Path)eachPrettyDir.resolve(FileUtil.escapeFileName((String)SingleAyaFile.nameOf(i, item)) + fileExt), (String)toString.apply(thisDoc, false));
        }
        FileUtil.writeString((Path)prettyDir.resolve(fileName), (String)toString.apply(Doc.vcat((SeqLike)docs), true));
    }

    @NotNull
    private static String nameOf(int i, AyaDocile item) {
        String string;
        if (item instanceof Def) {
            Def def = (Def)item;
            string = def.ref().name();
        } else if (item instanceof Decl) {
            Decl decl = (Decl)item;
            string = decl.ref().name();
        } else {
            string = String.valueOf(i);
        }
        return string;
    }

    default public void resolveAdditional(@NotNull ResolveInfo info) {
    }

    @MustBeInvokedByOverriders
    default public void tyckAdditional(@NotNull ResolveInfo info) {
        this.resolveAdditional(info);
    }

    @NotNull
    private static MarkdownAyaFile.Data createData(@NotNull CodeAyaFile template, @NotNull Reporter reporter) {
        SourceFile mdFile = template.originalFile;
        AyaMdParser mdParser = new AyaMdParser(mdFile, reporter);
        Literate lit = mdParser.parseLiterate();
        String ayaCode = mdParser.extractAya(lit);
        ImmutableSeq exprs = new LiterateConsumer.Codes(MutableList.create()).extract(lit);
        SourceFile code = new SourceFile(mdFile.display(), mdFile.underlying(), ayaCode);
        return new MarkdownAyaFile.Data(lit, (ImmutableSeq<Literate.Code>)exprs, code);
    }

    @VisibleForTesting
    @NotNull
    public static MarkdownAyaFile createLiterateFile(@NotNull CodeAyaFile template, @NotNull Reporter reporter) {
        return new MarkdownAyaFile(template.originalFile, SingleAyaFile.createData(template, reporter));
    }

    public record CodeAyaFile(@NotNull SourceFile originalFile) implements SingleAyaFile
    {
    }

    public record MarkdownAyaFile(@NotNull SourceFile originalFile, @NotNull Data data) implements SingleAyaFile
    {
        @Override
        public void resolveAdditional(@NotNull ResolveInfo info) {
            SingleAyaFile.super.resolveAdditional(info);
            this.data.extractedExprs.forEach(c -> {
                assert (c.expr != null);
                c.expr = new Desugarer(info).apply(c.expr.resolveLax(info.thisModule()));
            });
        }

        @Override
        public void tyckAdditional(@NotNull ResolveInfo info) {
            SingleAyaFile.super.tyckAdditional(info);
            ExprTycker tycker = info.newTycker(info.thisModule().reporter(), null);
            this.data.extractedExprs.forEach(c -> {
                assert (c.expr != null);
                c.tyckResult = tycker.zonk(tycker.synthesize(c.expr)).normalize(c.options.mode(), tycker.state);
            });
        }

        @NotNull
        public ImmutableSeq<Stmt> parseMe(@NotNull GenericAyaParser parser) throws IOException {
            this.data.extractedExprs.forEach(code -> {
                code.expr = parser.expr(code.code, code.sourcePos);
            });
            return SingleAyaFile.super.parseMe(parser);
        }

        @NotNull
        public SourceFile codeFile() {
            return this.data.extractedAya;
        }

        @NotNull
        public Literate literate() throws IOException {
            return this.data.literate;
        }

        record Data(@NotNull Literate literate, @NotNull ImmutableSeq<Literate.Code> extractedExprs, @NotNull SourceFile extractedAya) {
        }
    }

    public record Factory(@NotNull Reporter reporter) implements GenericAyaFile.Factory
    {
        @NotNull
        public SingleAyaFile createAyaFile(@NotNull SourceFileLocator locator, @NotNull Path path) throws IOException {
            String fileName = path.getFileName().toString();
            CodeAyaFile codeFile = new CodeAyaFile(SourceFile.from((SourceFileLocator)locator, (Path)path));
            return fileName.endsWith(".aya.md") ? SingleAyaFile.createLiterateFile(codeFile, this.reporter) : codeFile;
        }
    }
}

