/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.render.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import kala.control.Either;
import org.jetbrains.annotations.NotNull;

public class EitherAdapter
implements JsonSerializer<Either<?, ?>>,
JsonDeserializer<Either<?, ?>> {
    public static boolean bestMatch(@NotNull JsonElement json, @NotNull Type type) {
        if (json.isJsonPrimitive()) {
            Class clazz;
            JsonPrimitive prim = json.getAsJsonPrimitive();
            return prim.isString() && type == String.class || prim.isNumber() && type instanceof Class && Number.class.isAssignableFrom(clazz = (Class)type) || prim.isBoolean() && type == Boolean.class;
        }
        return false;
    }

    public JsonElement serialize(Either<?, ?> src, Type typeOfSrc, JsonSerializationContext context) {
        assert (src != null);
        assert (typeOfSrc != null);
        assert (context != null);
        if (typeOfSrc instanceof ParameterizedType) {
            ParameterizedType generic = (ParameterizedType)typeOfSrc;
            Type[] typeArgs = generic.getActualTypeArguments();
            assert (typeArgs.length == 2);
            return (JsonElement)src.fold(x -> context.serialize(x, typeArgs[0]), x -> context.serialize(x, typeArgs[1]));
        }
        throw new JsonParseException("Unable to serialize an Either<?, ?> without a ParameterizedType");
    }

    public Either<?, ?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        assert (json != null);
        assert (typeOfT != null);
        assert (context != null);
        if (typeOfT instanceof ParameterizedType) {
            ParameterizedType generic = (ParameterizedType)typeOfT;
            Type[] typeArgs = generic.getActualTypeArguments();
            assert (typeArgs.length == 2);
            boolean bestMatch0 = EitherAdapter.bestMatch(json, typeArgs[0]);
            boolean bestMatch1 = EitherAdapter.bestMatch(json, typeArgs[1]);
            if (bestMatch0) {
                return Either.left((Object)context.deserialize(json, typeArgs[0]));
            }
            if (bestMatch1) {
                return Either.right((Object)context.deserialize(json, typeArgs[1]));
            }
            try {
                return Either.left((Object)context.deserialize(json, typeArgs[0]));
            }
            catch (JsonParseException ex) {
                return Either.right((Object)context.deserialize(json, typeArgs[1]));
            }
        }
        throw new JsonParseException("Unable to deserialize an Either<?, ?> without a ParameterizedType");
    }
}

