/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.parse;

import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FleetPsiParser;
import com.intellij.psi.TokenType;
import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.psi.builder.MarkerNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import java.nio.file.Path;
import java.util.Objects;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Either;
import org.aya.cli.parse.AyaProducer;
import org.aya.concrete.Expr;
import org.aya.concrete.GenericAyaParser;
import org.aya.concrete.error.ParseError;
import org.aya.concrete.stmt.Stmt;
import org.aya.parser.AyaLanguage;
import org.aya.parser.AyaParserDefinitionBase;
import org.aya.parser.AyaPsiElementTypes;
import org.aya.parser.GenericNode;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;

public record AyaParserImpl(@NotNull Reporter reporter) implements GenericAyaParser
{
    @NotNull
    private static final TokenSet ERROR = TokenSet.create((IElementType[])new IElementType[]{TokenType.ERROR_ELEMENT, TokenType.BAD_CHARACTER});

    @NotNull
    public GenericNode<?> parseNode(@NotNull String code) {
        AyaFleetParser parser = new AyaFleetParser();
        return new NodeWrapper(parser.parse(code));
    }

    @NotNull
    public Expr expr(@NotNull String code, @NotNull SourcePos sourcePos) {
        GenericNode<?> node = this.parseNode("prim a : " + code);
        GenericNode type = node.child(AyaPsiElementTypes.PRIM_DECL).child(AyaPsiElementTypes.TYPE);
        return new AyaProducer((Either<SourceFile, SourcePos>)Either.right((Object)sourcePos), this.reporter).type(type);
    }

    @NotNull
    public ImmutableSeq<Stmt> program(@NotNull SourceFile sourceFile, @NotNull SourceFile errorReport) {
        Either<ImmutableSeq<Stmt>, Expr> parse = this.parse(sourceFile.sourceCode(), errorReport);
        if (parse.isRight()) {
            this.reporter.reportString("Expect statement, got repl expression", Problem.Severity.ERROR);
            return ImmutableSeq.empty();
        }
        return (ImmutableSeq)parse.getLeftValue();
    }

    @NotNull
    private Either<ImmutableSeq<Stmt>, Expr> parse(@NotNull String code, @NotNull SourceFile errorReport) {
        GenericNode<?> node = this.reportErrorElements(this.parseNode(code), errorReport);
        return new AyaProducer((Either<SourceFile, SourcePos>)Either.left((Object)errorReport), this.reporter).program(node);
    }

    @NotNull
    public Either<ImmutableSeq<Stmt>, Expr> repl(@NotNull String code) {
        return this.parse(code, AyaParserImpl.replSourceFile(code));
    }

    @NotNull
    private static SourceFile replSourceFile(@NotNull String text) {
        return new SourceFile("<stdin>", Path.of("stdin", new String[0]), text);
    }

    @NotNull
    private GenericNode<?> reportErrorElements(@NotNull GenericNode<?> node, @NotNull SourceFile file) {
        node.childrenView().filter(i -> ERROR.contains(i.elementType())).forEach(e -> this.reporter.report((Problem)new ParseError(AyaProducer.sourcePosOf(e, file), "Cannot parse")));
        return node;
    }

    private static class AyaFleetParser
    extends FleetPsiParser.DefaultPsiParser {
        public AyaFleetParser() {
            super((ParserDefinition)new AyaFleetParserDefinition());
        }

        private static final class AyaFleetParserDefinition
        extends AyaParserDefinitionBase {
            @NotNull
            private final IFileElementType FILE = new IFileElementType(this, (Language)AyaLanguage.INSTANCE){

                public void parse(@NotNull FleetPsiBuilder<?> builder) {
                }
            };

            private AyaFleetParserDefinition() {
            }

            @NotNull
            public IFileElementType getFileNodeType() {
                return this.FILE;
            }
        }
    }

    private record NodeWrapper(@NotNull MarkerNode node) implements GenericNode<NodeWrapper>
    {
        @NotNull
        public IElementType elementType() {
            return this.node.elementType();
        }

        @NotNull
        public String tokenText() {
            if (this.isTerminalNode()) {
                return Objects.requireNonNull(this.node.text());
            }
            StringBuilder sb = new StringBuilder();
            this.buildText(sb);
            return sb.toString();
        }

        public boolean isTerminalNode() {
            return this.node.text() != null;
        }

        @NotNull
        public SeqView<NodeWrapper> childrenView() {
            return this.node.children().view().map(NodeWrapper::new);
        }

        private void buildText(@NotNull StringBuilder builder) {
            if (this.node.text() != null) {
                builder.append(this.node.text());
            } else {
                this.childrenView().forEach(c -> c.buildText(builder));
            }
        }

        @NotNull
        public TextRange range() {
            return this.node.range();
        }

        @NotNull
        public String toDebugString() {
            return this.node.toDebugString("  ");
        }
    }
}

