/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.literate.FaithfulPrettier;
import org.aya.cli.literate.HighlightInfo;
import org.aya.concrete.remark.Literate;
import org.aya.concrete.remark.LiterateConsumer;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

public class HighlightsCollector
implements LiterateConsumer {
    @NotNull
    public final ImmutableSeq<HighlightInfo> highlights;
    @NotNull
    private final FaithfulPrettier prettier;

    public HighlightsCollector(@NotNull ImmutableSeq<HighlightInfo> highlights, @NotNull PrettierOptions options) {
        this.highlights = highlights;
        this.prettier = new FaithfulPrettier(options);
    }

    public void accept(@NotNull Literate literate) {
        Literate.CodeBlock codeBlock;
        if (literate instanceof Literate.CodeBlock && (codeBlock = (Literate.CodeBlock)literate).isAya() && codeBlock.sourcePos != null) {
            ImmutableSeq hl = this.highlights.filter(x -> codeBlock.sourcePos.containsIndex(x.sourcePos()));
            codeBlock.highlighted = this.prettier.highlight(codeBlock.raw, codeBlock.sourcePos.tokenStartIndex(), (ImmutableSeq<HighlightInfo>)hl);
        }
        super.accept(literate);
    }
}

