/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import org.aya.generic.AyaDocile;
import org.aya.pretty.doc.Link;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record HighlightInfo(@NotNull SourcePos sourcePos, @NotNull HighlightSymbol type) implements Comparable<HighlightInfo>
{
    @Override
    public int compareTo(@NotNull HighlightInfo o) {
        return this.sourcePos.compareTo(o.sourcePos);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface HighlightSymbol {
        @NotNull
        default public HighlightInfo toInfo(@NotNull SourcePos sourcePos) {
            return new HighlightInfo(sourcePos, this);
        }
    }

    public record SymLit(@NotNull LitKind kind) implements HighlightSymbol
    {
    }

    public record SymError(@NotNull AyaDocile docile) implements HighlightSymbol
    {
    }

    public record SymDef(@NotNull Link target, @NotNull DefKind kind, @Nullable AyaDocile type) implements HighlightSymbol
    {
    }

    public record SymRef(@NotNull Link target, @NotNull DefKind kind, @Nullable AyaDocile type) implements HighlightSymbol
    {
    }

    public static enum LitKind {
        Int,
        String,
        Keyword,
        Comment,
        SpecialSymbol,
        Eol,
        Whitespace;


        @NotNull
        public HighlightInfo toLit(@NotNull SourcePos sourcePos) {
            return new HighlightInfo(sourcePos, new SymLit(this));
        }
    }

    public static enum DefKind {
        Data,
        Con,
        Struct,
        Field,
        Fn,
        Prim,
        Generalized,
        LocalVar,
        Module,
        Unknown;


        @NotNull
        public HighlightInfo toRef(@NotNull SourcePos sourcePos, @NotNull Link target, @Nullable AyaDocile type) {
            return new HighlightInfo(sourcePos, new SymRef(target, this, type));
        }

        @NotNull
        public HighlightInfo toDef(@NotNull SourcePos sourcePos, @NotNull Link target, @Nullable AyaDocile type) {
            return new HighlightInfo(sourcePos, new SymDef(target, this, type));
        }
    }
}

