/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import java.util.Iterator;
import java.util.List;
import kala.collection.mutable.MutableList;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Document;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Node;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.PostProcessor;

public class FillCodeBlock
implements PostProcessor {
    public static final FillCodeBlock INSTANCE = new FillCodeBlock();
    public static final Visitor VISITOR = new Visitor();

    private FillCodeBlock() {
    }

    public Node process(Node node) {
        if (node instanceof Document) {
            Document doc = (Document)node;
            VISITOR.visit(doc);
        }
        return node;
    }

    public static final class Visitor
    extends AbstractVisitor {
        private Visitor() {
        }

        public void visit(FencedCodeBlock codeBlock) {
            List sourceSpans;
            if (codeBlock != null && (sourceSpans = codeBlock.getSourceSpans()) != null && sourceSpans.size() >= 2) {
                Iterator it = sourceSpans.iterator();
                SourceSpan lastSpan = (SourceSpan)it.next();
                MutableList conSourceSpans = MutableList.of((Object)lastSpan);
                while (it.hasNext()) {
                    SourceSpan curSpan = (SourceSpan)it.next();
                    while (lastSpan.getLineIndex() + 1 != curSpan.getLineIndex()) {
                        lastSpan = SourceSpan.of((int)(lastSpan.getLineIndex() + 1), (int)-1, (int)0);
                        conSourceSpans.append((Object)lastSpan);
                    }
                    lastSpan = curSpan;
                    conSourceSpans.append((Object)lastSpan);
                }
                codeBlock.setSourceSpans(conSourceSpans.asJava());
            }
            super.visit(codeBlock);
        }
    }
}

