/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import com.intellij.openapi.util.text.StringUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.text.StringSlice;
import org.aya.cli.literate.HighlightInfo;
import org.aya.generic.AyaDocile;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Link;
import org.aya.pretty.doc.Style;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FaithfulPrettier(@NotNull PrettierOptions options) {
    private static void checkHighlights(@NotNull ImmutableSeq<HighlightInfo> highlights) {
        highlights.foldLeft((Object)-1, (lastEndIndex, h) -> {
            SourcePos sp = h.sourcePos();
            if (sp.tokenStartIndex() > sp.tokenEndIndex()) {
                throw new IllegalArgumentException("Invalid source pos: " + String.valueOf(sp));
            }
            if (lastEndIndex >= sp.tokenStartIndex()) {
                throw new IllegalArgumentException("Intersect with previous source pos: " + String.valueOf(sp));
            }
            return sp.tokenEndIndex();
        });
    }

    @NotNull
    public Doc highlight(@NotNull String raw, int base, @NotNull ImmutableSeq<HighlightInfo> highlights) {
        highlights = highlights.sorted().view().distinct().filter(h -> h.sourcePos() != SourcePos.NONE).filterNot(h -> h.sourcePos().isEmpty()).toImmutableSeq();
        FaithfulPrettier.checkHighlights((ImmutableSeq<HighlightInfo>)highlights);
        return this.doHighlight(StringSlice.of((String)raw), base, (ImmutableSeq<HighlightInfo>)highlights);
    }

    @NotNull
    private Doc doHighlight(@NotNull StringSlice raw, int base, @NotNull ImmutableSeq<HighlightInfo> highlights) {
        MutableList docs = MutableList.create();
        for (HighlightInfo current : highlights) {
            Doc highlight;
            KnifeCut knifeCut = FaithfulPrettier.twoKnifeThreeParts(raw, base, current.sourcePos());
            raw = knifeCut.remaining;
            base = knifeCut.base;
            if (!knifeCut.before.isEmpty()) {
                docs.append((Object)Doc.plain((String)knifeCut.before.toString()));
            }
            if ((highlight = this.highlightOne(knifeCut.current.toString(), current.type())) == Doc.empty()) continue;
            docs.append((Object)highlight);
        }
        if (!raw.isEmpty()) {
            docs.append((Object)Doc.plain((String)raw.toString()));
        }
        return Doc.cat((SeqLike)docs);
    }

    @NotNull
    private Doc highlightOne(@NotNull String raw, @NotNull HighlightInfo.HighlightSymbol highlight) {
        if (raw.isEmpty()) {
            return Doc.empty();
        }
        HighlightInfo.HighlightSymbol highlightSymbol = highlight;
        Objects.requireNonNull(highlightSymbol);
        HighlightInfo.HighlightSymbol highlightSymbol2 = highlightSymbol;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HighlightInfo.SymDef.class, HighlightInfo.SymRef.class, HighlightInfo.SymLit.class, HighlightInfo.SymError.class}, (Object)highlightSymbol2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                HighlightInfo.SymDef symDef = (HighlightInfo.SymDef)highlightSymbol2;
                yield Doc.linkDef((Doc)this.highlightVar(raw, symDef.kind()), (Link)symDef.target(), (String)this.hover(symDef.type()));
            }
            case 1 -> {
                HighlightInfo.SymRef symRef = (HighlightInfo.SymRef)highlightSymbol2;
                yield Doc.linkRef((Doc)this.highlightVar(raw, symRef.kind()), (Link)symRef.target(), (String)this.hover(symRef.type()));
            }
            case 2 -> {
                HighlightInfo.SymLit symLit = (HighlightInfo.SymLit)highlightSymbol2;
                yield this.highlightLit(raw, symLit.kind());
            }
            case 3 -> {
                HighlightInfo.SymError symError = (HighlightInfo.SymError)highlightSymbol2;
                yield Doc.plain((String)raw);
            }
        };
    }

    @Nullable
    private String hover(@Nullable AyaDocile term) {
        if (term == null) {
            return null;
        }
        return term.toDoc(this.options()).commonRender();
    }

    @NotNull
    private Doc highlightVar(@NotNull String raw, @NotNull HighlightInfo.DefKind defKind) {
        Style style = switch (defKind) {
            default -> throw new IncompatibleClassChangeError();
            case HighlightInfo.DefKind.Data -> BasePrettier.DATA;
            case HighlightInfo.DefKind.Con -> BasePrettier.CON;
            case HighlightInfo.DefKind.Struct -> BasePrettier.STRUCT;
            case HighlightInfo.DefKind.Field -> BasePrettier.FIELD;
            case HighlightInfo.DefKind.Fn -> BasePrettier.FN;
            case HighlightInfo.DefKind.Prim -> BasePrettier.PRIM;
            case HighlightInfo.DefKind.Generalized -> BasePrettier.GENERALIZED;
            case HighlightInfo.DefKind.LocalVar -> BasePrettier.LOCAL_VAR;
            case HighlightInfo.DefKind.Unknown, HighlightInfo.DefKind.Module -> null;
        };
        return style != null ? Doc.styled((Style)style, (String)raw) : Doc.plain((String)raw);
    }

    @NotNull
    private Doc highlightLit(@NotNull String raw, @NotNull HighlightInfo.LitKind litKind) {
        return switch (litKind) {
            default -> throw new IncompatibleClassChangeError();
            case HighlightInfo.LitKind.Int, HighlightInfo.LitKind.Whitespace -> Doc.plain((String)raw);
            case HighlightInfo.LitKind.String -> Doc.plain((String)StringUtil.escapeStringCharacters((String)raw));
            case HighlightInfo.LitKind.Keyword -> Doc.styled((Style)BasePrettier.KEYWORD, (Doc)Doc.symbol((String)raw));
            case HighlightInfo.LitKind.Comment -> Doc.styled((Style)BasePrettier.COMMENT, (String)raw);
            case HighlightInfo.LitKind.SpecialSymbol -> Doc.symbol((String)raw);
            case HighlightInfo.LitKind.Eol -> Doc.cat((SeqLike)Seq.fill((int)raw.length(), (Object)Doc.line()));
        };
    }

    @NotNull
    private static KnifeCut twoKnifeThreeParts(@NotNull StringSlice raw, int base, @NotNull SourcePos twoKnife) {
        int beginPart1 = twoKnife.tokenStartIndex() - base;
        int endPart1 = twoKnife.tokenEndIndex() + 1 - base;
        StringSlice part0 = raw.subSequence(0, beginPart1);
        StringSlice part1 = raw.subSequence(beginPart1, endPart1);
        StringSlice part2 = raw.subSequence(endPart1, raw.length());
        return new KnifeCut(part0, part1, part2, twoKnife.tokenEndIndex() + 1);
    }

    record KnifeCut(@NotNull StringSlice before, @NotNull StringSlice current, @NotNull StringSlice remaining, int base) {
    }
}

