/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.literate;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.tuple.primitive.IntObjTuple2;
import kala.value.MutableValue;
import org.aya.cli.literate.FillCodeBlock;
import org.aya.concrete.remark.CodeAttrProcessor;
import org.aya.concrete.remark.CodeOptions;
import org.aya.concrete.remark.Literate;
import org.aya.concrete.remark.LiterateConsumer;
import org.aya.concrete.remark.UnsupportedMarkdown;
import org.aya.generic.util.InternalException;
import org.aya.pretty.backend.md.MdStyle;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.util.StringUtil;
import org.aya.util.error.SourceFile;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.parser.IncludeSourceSpans;
import org.commonmark.parser.Parser;
import org.commonmark.parser.PostProcessor;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AyaMdParser {
    @NotNull
    private final ImmutableSeq<Integer> linesIndex;
    @NotNull
    private final SourceFile file;
    @NotNull
    private final Reporter reporter;

    public AyaMdParser(@NotNull SourceFile file, @NotNull Reporter reporter) {
        this.file = file;
        this.reporter = reporter;
        this.linesIndex = StringUtil.indexedLines((String)file.sourceCode()).map(IntObjTuple2::component1);
    }

    @NotNull
    public Literate parseLiterate() {
        Parser parser = Parser.builder().customDelimiterProcessor((DelimiterProcessor)CodeAttrProcessor.INSTANCE).includeSourceSpans(IncludeSourceSpans.BLOCKS_AND_INLINES).postProcessor((PostProcessor)FillCodeBlock.INSTANCE).build();
        return this.mapAST(parser.parse(this.file.sourceCode()));
    }

    @NotNull
    public String extractAya(@NotNull Literate literate) {
        SeqView codeBlocks = new LiterateConsumer.AyaCodeBlocks(MutableList.create()).extract(literate).view().filter(x -> x.sourcePos != null);
        StringBuilder builder = new StringBuilder(this.file.sourceCode().length());
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Literate.CodeBlock head = (Literate.CodeBlock)codeBlocks.firstOrNull();
        codeBlocks = codeBlocks.drop(1);
        for (int idx = 0; idx < this.file.sourceCode().length(); ++idx) {
            char theChar = this.file.sourceCode().charAt(idx);
            if (head != null) {
                assert (head.sourcePos != null) : "Physical doesn't exist!!";
                if (head.sourcePos.tokenEndIndex() < idx) {
                    assert (idx - head.sourcePos.tokenEndIndex() == 1);
                    head = (Literate.CodeBlock)codeBlocks.firstOrNull();
                    codeBlocks = codeBlocks.drop(1);
                }
                assert (head == null || head.sourcePos != null) : "Physical doesn't exist!!";
                if (head != null && head.sourcePos.contains(idx)) {
                    builder.append(theChar);
                    continue;
                }
            }
            builder.append(theChar == '\n' ? (char)'\n' : ' ');
        }
        return builder.toString();
    }

    @NotNull
    private ImmutableSeq<Literate> mapChildren(@NotNull Node parent) {
        MutableList children = MutableList.create();
        Node node = parent.getFirstChild();
        while (node != null) {
            if (children.isNotEmpty() && node instanceof Paragraph) {
                children.append((Object)new Literate.Raw(Doc.line()));
            }
            Node next = node.getNext();
            children.append((Object)this.mapAST(node));
            node = next;
        }
        return children.toImmutableSeq();
    }

    @NotNull
    private Literate mapAST(@NotNull Node node) {
        Literate.Raw raw;
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        block20: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Text.class, Emphasis.class, HardLineBreak.class, SoftLineBreak.class, StrongEmphasis.class, Paragraph.class, BlockQuote.class, Heading.class, Link.class, Image.class, ListItem.class, OrderedList.class, BulletList.class, Document.class, HtmlBlock.class, ThematicBreak.class, FencedCodeBlock.class, Code.class}, (Object)node3, n)) {
                case 0: {
                    Text text = (Text)node3;
                    raw = new Literate.Raw(Doc.plain((String)text.getLiteral()));
                    break block20;
                }
                case 1: {
                    Emphasis emphasis = (Emphasis)node3;
                    raw = new Literate.Many(Style.italic(), this.mapChildren((Node)emphasis));
                    break block20;
                }
                case 2: {
                    HardLineBreak $ = (HardLineBreak)node3;
                    raw = new Literate.Raw(Doc.line());
                    break block20;
                }
                case 3: {
                    SoftLineBreak $ = (SoftLineBreak)node3;
                    raw = new Literate.Raw(Doc.line());
                    break block20;
                }
                case 4: {
                    StrongEmphasis emphasis = (StrongEmphasis)node3;
                    raw = new Literate.Many(Style.bold(), this.mapChildren((Node)emphasis));
                    break block20;
                }
                case 5: {
                    Paragraph p = (Paragraph)node3;
                    raw = new Literate.Many((Style)MdStyle.GFM.Paragraph, this.mapChildren((Node)p));
                    break block20;
                }
                case 6: {
                    BlockQuote b = (BlockQuote)node3;
                    raw = new Literate.Many((Style)MdStyle.GFM.BlockQuote, this.mapChildren((Node)b));
                    break block20;
                }
                case 7: {
                    Heading h = (Heading)node3;
                    raw = new Literate.Many((Style)new MdStyle.Heading(h.getLevel()), this.mapChildren((Node)h));
                    break block20;
                }
                case 8: {
                    Link h = (Link)node3;
                    raw = new Literate.HyperLink(h.getDestination(), h.getTitle(), this.mapChildren((Node)h));
                    break block20;
                }
                case 9: {
                    Image h = (Image)node3;
                    raw = new Literate.Image(h.getDestination(), this.mapChildren((Node)h));
                    break block20;
                }
                case 10: {
                    ListItem item = (ListItem)node3;
                    raw = this.flatten((Seq<Literate>)AyaMdParser.collectChildren(item.getFirstChild()).flatMap(this::mapChildren).toImmutableSeq());
                    break block20;
                }
                case 11: {
                    OrderedList ordered = (OrderedList)node3;
                    raw = new Literate.List(this.mapChildren((Node)ordered), true);
                    break block20;
                }
                case 12: {
                    BulletList bullet = (BulletList)node3;
                    raw = new Literate.List(this.mapChildren((Node)bullet), false);
                    break block20;
                }
                case 13: {
                    Document d = (Document)node3;
                    raw = this.flatten((Seq<Literate>)this.mapChildren((Node)d));
                    break block20;
                }
                case 14: {
                    HtmlBlock html = (HtmlBlock)node3;
                    if (!html.getLiteral().startsWith("<!--")) {
                        n = 15;
                        continue block20;
                    }
                    raw = new Literate.Raw(Doc.empty());
                    break block20;
                }
                case 15: {
                    ThematicBreak t = (ThematicBreak)node3;
                    raw = new Literate.Many((Style)MdStyle.GFM.ThematicBreak, this.mapChildren((Node)t));
                    break block20;
                }
                case 16: {
                    FencedCodeBlock codeBlock = (FencedCodeBlock)node3;
                    String language = codeBlock.getInfo();
                    String raw2 = codeBlock.getLiteral();
                    List spans = codeBlock.getSourceSpans();
                    if (spans != null && spans.size() >= 2) {
                        ImmutableSeq inner = ImmutableSeq.from((Collection)spans).view().drop(1).dropLast(1).toImmutableSeq();
                        if (!raw2.isEmpty()) {
                            raw2 = raw2.substring(0, raw2.length() - 1);
                        }
                        raw = new Literate.CodeBlock(this.fromSourceSpans((Seq<SourceSpan>)inner), language, raw2);
                        break block20;
                    }
                    throw new InternalException("SourceSpans");
                }
                case 17: {
                    Code inlineCode = (Code)node3;
                    List spans = inlineCode.getSourceSpans();
                    if (spans != null && spans.size() == 1) {
                        SourceSpan sourceSpan = (SourceSpan)spans.get(0);
                        Integer lineIndex = (Integer)this.linesIndex.get(sourceSpan.getLineIndex());
                        int startFrom = lineIndex + sourceSpan.getColumnIndex();
                        SourcePos sourcePos = AyaMdParser.fromSourceSpans(this.file, startFrom, (Seq<SourceSpan>)Seq.of((Object)sourceSpan));
                        assert (sourcePos != null);
                        raw = CodeOptions.analyze((Code)inlineCode, (SourcePos)sourcePos);
                        break block20;
                    }
                    throw new InternalException("SourceSpans");
                }
                default: {
                    List spans = node.getSourceSpans();
                    if (spans == null) {
                        throw new InternalException("SourceSpans");
                    }
                    SourcePos pos = this.fromSourceSpans((Seq<SourceSpan>)Seq.from((Iterable)spans));
                    if (pos == null) {
                        throw new UnsupportedOperationException("TODO: Which do the nodes have not source spans?");
                    }
                    this.reporter.report((Problem)new UnsupportedMarkdown(pos, node.getClass().getSimpleName()));
                    raw = new Literate.Unsupported(this.mapChildren(node));
                    break block20;
                }
            }
            break;
        }
        return raw;
    }

    private Literate flatten(@NotNull Seq<Literate> children) {
        return children.sizeEquals(1) ? (Literate)children.first() : new Literate.Many(null, children.toImmutableSeq());
    }

    @NotNull
    private static SeqView<Node> collectChildren(@NotNull Node firstChild) {
        MutableValue itemStore = MutableValue.create((Object)firstChild);
        return Seq.generateUntilNull(() -> (Node)itemStore.updateAndGet(Node::getNext)).view().prepended((Object)firstChild);
    }

    @Nullable
    public SourcePos fromSourceSpans(@NotNull Seq<SourceSpan> sourceSpans) {
        if (sourceSpans.isEmpty()) {
            return null;
        }
        Integer startFrom = (Integer)this.linesIndex.get(((SourceSpan)sourceSpans.first()).getLineIndex());
        return AyaMdParser.fromSourceSpans(this.file, startFrom, sourceSpans);
    }

    @Contract(pure=true)
    @Nullable
    public static SourcePos fromSourceSpans(@NotNull SourceFile file, int startFrom, @NotNull Seq<SourceSpan> sourceSpans) {
        SourceSpan beginSpan;
        if (sourceSpans.isEmpty()) {
            return null;
        }
        Iterator it = sourceSpans.iterator();
        SourceSpan endSpan = beginSpan = (SourceSpan)it.next();
        int endLine = beginSpan.getLineIndex();
        int endColumn = beginSpan.getLength() - 1;
        int totalLength = beginSpan.getLength();
        while (it.hasNext()) {
            SourceSpan curSpan = (SourceSpan)it.next();
            while (endSpan.getLineIndex() + 1 != curSpan.getLineIndex()) {
                ++totalLength;
                endSpan = SourceSpan.of((int)(endSpan.getLineIndex() + 1), (int)-1, (int)0);
            }
            endLine = curSpan.getLineIndex();
            endColumn = curSpan.getLength() - 1;
            totalLength += 1 + curSpan.getLength();
            endSpan = curSpan;
        }
        return new SourcePos(file, startFrom, startFrom + totalLength - 1, beginSpan.getLineIndex() + 1, beginSpan.getColumnIndex(), endLine + 1, endColumn);
    }
}

