/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.source;

import java.nio.file.Path;
import kala.collection.SeqView;
import kala.collection.mutable.MutableList;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.util.FileUtil;
import org.jetbrains.annotations.NotNull;

public interface MutableLibraryOwner
extends LibraryOwner {
    @NotNull
    public MutableList<Path> modulePathMut();

    @NotNull
    public MutableList<LibrarySource> librarySourcesMut();

    @NotNull
    public MutableList<LibraryOwner> libraryDepsMut();

    @Override
    @NotNull
    default public SeqView<Path> modulePath() {
        return this.modulePathMut().view();
    }

    @Override
    @NotNull
    default public SeqView<LibrarySource> librarySources() {
        return this.librarySourcesMut().view();
    }

    @Override
    @NotNull
    default public SeqView<LibraryOwner> libraryDeps() {
        return this.libraryDepsMut().view();
    }

    @Override
    default public void addModulePath(@NotNull Path newPath) {
        this.modulePathMut().append((Object)newPath);
    }

    default public void removeLibrarySource(@NotNull LibrarySource source) {
        this.librarySourcesMut().removeIf(src -> src == source);
    }

    @NotNull
    default public LibrarySource addLibrarySource(@NotNull Path source) {
        LibrarySource src = new LibrarySource(this, FileUtil.canonicalize((Path)source));
        this.librarySourcesMut().append((Object)src);
        return src;
    }
}

