/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.source;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.IntStream;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.value.MutableValue;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.concrete.GenericAyaFile;
import org.aya.concrete.GenericAyaParser;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.GenericDef;
import org.aya.generic.util.AyaFiles;
import org.aya.resolve.ResolveInfo;
import org.aya.util.FileUtil;
import org.aya.util.error.SourceFile;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(text="file")
public record LibrarySource(@NotNull LibraryOwner owner, @NotNull Path underlyingFile, @NotNull MutableList<LibrarySource> imports, @NotNull MutableValue<ImmutableSeq<Stmt>> program, @NotNull MutableValue<ImmutableSeq<GenericDef>> tycked, @NotNull MutableValue<ResolveInfo> resolveInfo) implements GenericAyaFile
{
    public LibrarySource(@NotNull LibraryOwner owner, @NotNull Path file) {
        this(owner, FileUtil.canonicalize((Path)file), (MutableList<LibrarySource>)MutableList.create(), (MutableValue<ImmutableSeq<Stmt>>)MutableValue.create(), (MutableValue<ImmutableSeq<GenericDef>>)MutableValue.create(), (MutableValue<ResolveInfo>)MutableValue.create());
    }

    @NotNull
    public ImmutableSeq<String> moduleName() {
        ResolveInfo info = (ResolveInfo)this.resolveInfo.get();
        if (info != null) {
            return info.thisModule().modulePath().path();
        }
        Path display = this.displayPath();
        Path displayNoExt = display.resolveSibling(AyaFiles.stripAyaSourcePostfix((String)display.getFileName().toString()));
        return (ImmutableSeq)IntStream.range(0, displayNoExt.getNameCount()).mapToObj(i -> displayNoExt.getName(i).toString()).collect(ImmutableSeq.factory());
    }

    @NotNull
    public Path displayPath() {
        return this.owner.locator().displayName(this.underlyingFile);
    }

    @NotNull
    public SourceFile toSourceFile(@NotNull String sourceCode) {
        return new SourceFile(this.displayPath().toString(), this.underlyingFile, sourceCode);
    }

    @NotNull
    public ImmutableSeq<Stmt> parseMe(@NotNull GenericAyaParser parser) throws IOException {
        ImmutableSeq stmts = super.parseMe(parser);
        this.program.set((Object)stmts);
        return stmts;
    }

    @NotNull
    public SourceFile originalFile() throws IOException {
        return this.toSourceFile(Files.readString(this.underlyingFile));
    }

    @NotNull
    public Path compiledCorePath() {
        ImmutableSeq<String> mod = this.moduleName();
        return AyaFiles.resolveAyaCompiledFile((Path)this.owner.outDir(), mod);
    }

    @Override
    public String toString() {
        return this.underlyingFile.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibrarySource that = (LibrarySource)o;
        return this.owner.underlyingLibrary() == that.owner.underlyingLibrary() && this.underlyingFile.equals(that.underlyingFile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.owner.underlyingLibrary(), this.underlyingFile);
    }
}

