/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.source;

import java.nio.file.Path;
import java.util.Iterator;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.library.json.LibraryConfig;
import org.aya.cli.library.source.LibrarySource;
import org.aya.util.error.SourceFileLocator;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="underlyingLibrary().name()")
public interface LibraryOwner {
    public static final int DEFAULT_INDENT = 2;

    @NotNull
    public SeqView<Path> modulePath();

    @NotNull
    public SeqView<LibrarySource> librarySources();

    @NotNull
    public SeqView<LibraryOwner> libraryDeps();

    @NotNull
    public SourceFileLocator locator();

    @NotNull
    public LibraryConfig underlyingLibrary();

    public void addModulePath(@NotNull Path var1);

    @NotNull
    default public Path outDir() {
        return this.underlyingLibrary().libraryOutRoot();
    }

    @Nullable
    default public LibrarySource findModule(@NotNull ImmutableSeq<String> mod) {
        LibrarySource file;
        block1: {
            LibraryOwner dep;
            file = this.findModuleHere(mod);
            if (file != null) break block1;
            Iterator iterator = this.libraryDeps().iterator();
            while (iterator.hasNext() && (file = (dep = (LibraryOwner)iterator.next()).findModule(mod)) == null) {
            }
        }
        return file;
    }

    @Nullable
    private LibrarySource findModuleHere(@NotNull ImmutableSeq<String> mod) {
        return (LibrarySource)this.librarySources().find(s -> {
            ImmutableSeq<String> checkMod = s.moduleName();
            return checkMod.equals((Object)mod);
        }).getOrNull();
    }
}

