/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.json;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.library.json.LibraryConfig;
import org.aya.cli.library.json.LibraryDependency;
import org.aya.cli.library.json.LibraryDependencyData;
import org.aya.util.FileUtil;
import org.aya.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class LibraryConfigData {
    public String ayaVersion;
    public String name;
    public String group;
    public String version;
    public Map<String, LibraryDependencyData> dependency;

    @VisibleForTesting
    public void checkDeserialization(@NotNull Path libraryRoot) {
        if (this.ayaVersion == null) {
            this.ayaVersion = "0.28";
        }
        if (this.name == null) {
            throw new BadConfig("Missing `name` in " + String.valueOf(libraryRoot));
        }
        if (this.group == null) {
            throw new BadConfig("Missing `group` in " + String.valueOf(libraryRoot));
        }
        if (this.version == null) {
            throw new BadConfig("Missing `version in " + String.valueOf(libraryRoot));
        }
        if (this.dependency == null) {
            this.dependency = Map.of();
        }
    }

    @NotNull
    private LibraryConfig asConfig(@NotNull Path libraryRoot) throws JsonParseException {
        return this.asConfig(libraryRoot, config -> libraryRoot.resolve("build"));
    }

    @NotNull
    private LibraryConfig asConfig(@NotNull Path libraryRoot, @NotNull Function<String, Path> buildRootGen) {
        this.checkDeserialization(libraryRoot.resolve("aya.json"));
        Path buildRoot = FileUtil.canonicalize((Path)buildRootGen.apply(this.version));
        return new LibraryConfig(Version.create((String)this.ayaVersion), this.name, this.version, libraryRoot, libraryRoot.resolve("src"), buildRoot, buildRoot.resolve("out"), (ImmutableSeq<LibraryDependency>)ImmutableSeq.from(this.dependency.entrySet()).view().map(e -> ((LibraryDependencyData)e.getValue()).as(libraryRoot, (String)e.getKey())).toImmutableSeq());
    }

    @NotNull
    private static LibraryConfigData of(@NotNull Path root) throws BadConfig, IOException {
        Path ayaJson = root.resolve("aya.json");
        return LibraryConfigData.ofAyaJson(ayaJson);
    }

    @VisibleForTesting
    public static LibraryConfigData ofAyaJson(Path ayaJson) throws IOException {
        LibraryConfigData libraryConfigData;
        block8: {
            BufferedReader jsonReader = Files.newBufferedReader(ayaJson);
            try {
                libraryConfigData = (LibraryConfigData)new Gson().fromJson((Reader)jsonReader, LibraryConfigData.class);
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException cause) {
                    throw new BadConfig("Failed to parse " + String.valueOf(ayaJson), cause);
                }
            }
            jsonReader.close();
        }
        return libraryConfigData;
    }

    @NotNull
    public static LibraryConfig fromLibraryRoot(@NotNull Path libraryRoot) throws IOException, BadConfig {
        Path canonicalPath = FileUtil.canonicalize((Path)libraryRoot);
        return LibraryConfigData.of(canonicalPath).asConfig(canonicalPath);
    }

    @NotNull
    public static LibraryConfig fromDependencyRoot(@NotNull Path dependencyRoot, @NotNull Function<String, Path> buildRoot) throws IOException, BadConfig {
        Path canonicalPath = FileUtil.canonicalize((Path)dependencyRoot);
        return LibraryConfigData.of(canonicalPath).asConfig(canonicalPath, buildRoot);
    }

    public static class BadConfig
    extends RuntimeException {
        public BadConfig(@NotNull String message) {
            super(message);
        }

        public BadConfig(@NotNull String message, @NotNull Throwable cause) {
            super(message, cause);
        }
    }
}

