/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.library.incremental;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.library.incremental.CompilerAdvisor;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.utils.CompilerUtil;
import org.aya.core.def.GenericDef;
import org.aya.core.serde.CompiledAya;
import org.aya.core.serde.SerTerm;
import org.aya.core.serde.Serializer;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.FileUtil;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiskCompilerAdvisor
implements CompilerAdvisor {
    @Override
    public boolean isSourceModified(@NotNull LibrarySource source) {
        try {
            Path core = source.compiledCorePath();
            if (!Files.exists(core, new LinkOption[0])) {
                return true;
            }
            return Files.getLastModifiedTime(source.underlyingFile(), new LinkOption[0]).compareTo(Files.getLastModifiedTime(core, new LinkOption[0])) > 0;
        }
        catch (IOException ignore) {
            return true;
        }
    }

    @Override
    public void updateLastModified(@NotNull LibrarySource source) {
        try {
            Path core = source.compiledCorePath();
            Files.setLastModifiedTime(core, Files.getLastModifiedTime(source.underlyingFile(), new LinkOption[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void prepareLibraryOutput(@NotNull LibraryOwner owner) throws IOException {
        Files.createDirectories(owner.outDir(), new FileAttribute[0]);
    }

    @Override
    public void clearLibraryOutput(@NotNull LibraryOwner owner) throws IOException {
        FileUtil.deleteRecursively((Path)owner.outDir());
    }

    @Override
    public void clearModuleOutput(@NotNull LibrarySource source) throws IOException {
        Files.deleteIfExists(source.compiledCorePath());
    }

    @Override
    @Nullable
    public ResolveInfo doLoadCompiledCore(@NotNull SerTerm.DeState deState, @NotNull Reporter reporter, @NotNull ImmutableSeq<String> mod, @Nullable Path sourcePath, @Nullable Path corePath, @NotNull ModuleLoader recurseLoader) throws IOException, ClassNotFoundException {
        if (corePath == null || sourcePath == null) {
            return null;
        }
        if (!Files.exists(corePath, new LinkOption[0])) {
            return null;
        }
        PhysicalModuleContext context = new EmptyContext(reporter, sourcePath).derive(mod);
        try (ObjectInputStream inputStream = FileUtil.ois((Path)corePath);){
            CompiledAya compiledAya = (CompiledAya)inputStream.readObject();
            ResolveInfo resolveInfo = compiledAya.toResolveInfo(recurseLoader, context, deState);
            return resolveInfo;
        }
    }

    @Override
    public void doSaveCompiledCore(@NotNull Serializer.State serState, @NotNull LibrarySource file, @NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<GenericDef> defs) throws IOException {
        Path coreFile = file.compiledCorePath();
        CompilerUtil.saveCompiledCore(coreFile, resolveInfo, defs, serState);
    }
}

