/*
 * Decompiled with CFR 0.152.
 */
package org.aya.cli.interactive;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kala.control.Option;
import org.aya.cli.render.Color;
import org.aya.cli.render.RenderOptions;
import org.aya.generic.util.AyaHome;
import org.aya.generic.util.NormalizeMode;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.VisibleForTesting;

public class ReplConfig
implements AutoCloseable {
    public final transient Option<Path> configFile;
    @NotNull
    public String prompt = "> ";
    @NotNull
    public NormalizeMode normalizeMode = NormalizeMode.NF;
    @NotNull
    public AyaPrettierOptions prettierOptions = AyaPrettierOptions.pretty();
    public boolean enableUnicode = true;
    public boolean silent = false;
    public @UnknownNullability RenderOptions renderOptions = new RenderOptions();

    public ReplConfig(@NotNull Option<Path> file) {
        this.configFile = file;
    }

    private void checkDeserialization() {
        if (this.prettierOptions.map.isEmpty()) {
            this.prettierOptions.reset();
        }
        if (this.renderOptions == null) {
            this.renderOptions = new RenderOptions();
        }
        this.renderOptions.checkDeserialization();
        try {
            this.renderOptions.stylist(RenderOptions.OutputTarget.Unix);
        }
        catch (JsonParseException | IOException e) {
            System.err.println("Failed to load stylist from config file, using default stylist instead.");
        }
    }

    @NotNull
    public static ReplConfig loadFromDefault() throws IOException, JsonParseException {
        return ReplConfig.loadFrom(AyaHome.ayaHome().resolve("repl_config.json"));
    }

    @NotNull
    public static ReplConfig loadFrom(@NotNull Path file) throws IOException, JsonParseException {
        if (Files.notExists(file, new LinkOption[0])) {
            return new ReplConfig((Option<Path>)Option.some((Object)file));
        }
        return ReplConfig.loadFrom((Option<Path>)Option.some((Object)file), Files.readString(file));
    }

    @VisibleForTesting
    @NotNull
    public static ReplConfig loadFrom(@NotNull Option<Path> file, @NotNull String jsonText) throws JsonParseException {
        ReplConfig config = (ReplConfig)ReplConfig.newGsonBuilder().registerTypeAdapter(ReplConfig.class, type -> new ReplConfig(file)).create().fromJson(jsonText, ReplConfig.class);
        if (config == null) {
            return new ReplConfig(file);
        }
        config.checkDeserialization();
        return config;
    }

    @Override
    public void close() throws IOException {
        if (this.configFile.isDefined()) {
            Files.writeString((Path)this.configFile.get(), (CharSequence)ReplConfig.newGsonBuilder().create().toJson((Object)this), new OpenOption[0]);
        }
    }

    @VisibleForTesting
    public static GsonBuilder newGsonBuilder() {
        return new GsonBuilder().registerTypeAdapter(Color.class, (Object)new Color.Adapter()).registerTypeAdapter(PrettierOptions.Key.class, (json, typeOfT, context) -> {
            try {
                return AyaPrettierOptions.Key.valueOf((String)json.getAsString());
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        });
    }
}

