/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.maven.resolver;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.axway.grapes.maven.resolver.ArtifactResolver;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class LicenseResolver {
    private final MavenXpp3Reader reader = new MavenXpp3Reader();
    private final ArtifactResolver artifactResolver;

    public LicenseResolver(RepositorySystem repositorySystem, ArtifactRepository localRepository, Log log) {
        this.artifactResolver = new ArtifactResolver(repositorySystem, localRepository, log);
    }

    public List<License> resolve(MavenProject project) throws MojoExecutionException {
        ArrayList<License> licenses = new ArrayList<License>();
        licenses.addAll(project.getLicenses());
        if (licenses.isEmpty() && project.getParent() != null) {
            MavenProject parent = project.getParent();
            licenses.addAll(this.resolve(project, parent.getGroupId(), parent.getArtifactId(), parent.getVersion()));
        }
        return licenses;
    }

    public List<License> resolve(MavenProject project, String groupId, String artifactId, String version) throws MojoExecutionException {
        Artifact modelArtifact = this.getModelArtifact(groupId, artifactId, version);
        return this.getLicenses(project, modelArtifact);
    }

    private List<License> getLicenses(MavenProject project, Artifact modelArtifact) throws MojoExecutionException {
        try {
            ArrayList<License> licenses = new ArrayList<License>();
            this.artifactResolver.resolveArtifact(project, modelArtifact);
            Model model = this.reader.read((Reader)new FileReader(modelArtifact.getFile()));
            licenses.addAll(model.getLicenses());
            if (model.getParent() != null) {
                Parent parent = model.getParent();
                Artifact parentModel = this.getModelArtifact(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
                licenses.addAll(this.getLicenses(project, parentModel));
            }
            return licenses;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Failed to read " + modelArtifact.getFile(), (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Failed to read " + modelArtifact.getFile(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read " + modelArtifact.getFile(), (Exception)e);
        }
    }

    private Artifact getModelArtifact(String groupId, String artifactId, String version) {
        DefaultArtifactHandler handler = new DefaultArtifactHandler();
        handler.setExtension("pom");
        DefaultArtifact model = new DefaultArtifact(groupId, artifactId, version, null, "pom", null, (ArtifactHandler)handler);
        return model;
    }
}

