/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.maven.resolver;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

public class ArtifactResolver {
    private final RepositorySystem repositorySystem;
    private final ArtifactRepository localRepository;
    private final Log logger;

    public ArtifactResolver(RepositorySystem repositorySystem, ArtifactRepository localRepository, Log log) {
        this.repositorySystem = repositorySystem;
        this.localRepository = localRepository;
        this.logger = log;
    }

    public void resolveArtifact(MavenProject project, Artifact artifact) throws MojoExecutionException {
        this.logger.debug((CharSequence)("Resolving artifact " + artifact.toString()));
        ArtifactResolutionRequest artifactRequest = new ArtifactResolutionRequest();
        artifactRequest.setArtifact(artifact);
        artifactRequest.setLocalRepository(this.localRepository);
        artifactRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
        ArtifactResolutionResult resolutionResult = this.repositorySystem.resolve(artifactRequest);
        if (!resolutionResult.isSuccess()) {
            this.logger.debug((CharSequence)("Failed to resolved " + artifact.toString() + " artifact."));
        }
    }

    public Artifact resolveArtifact(MavenProject project, Dependency dependency) throws MojoExecutionException {
        String version = dependency.getVersion();
        try {
            if (!version.matches("[0-9.]*")) {
                VersionRange range = VersionRange.createFromVersionSpec((String)version);
                version = ArtifactResolver.getArtifactVersion(range);
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Failed to handle version range of " + dependency.toString(), (Exception)((Object)e));
        }
        DefaultArtifactHandler handler = new DefaultArtifactHandler();
        handler.setExtension(dependency.getType());
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), version, null, dependency.getType(), dependency.getClassifier(), (ArtifactHandler)handler);
        this.resolveArtifact(project, (Artifact)artifact);
        return artifact;
    }

    public static String getArtifactVersion(VersionRange range) {
        if (range.getRecommendedVersion() != null) {
            return range.getRecommendedVersion().toString();
        }
        if (range.hasRestrictions()) {
            for (Restriction restriction : range.getRestrictions()) {
                if (restriction.getLowerBound() != null) {
                    return restriction.getLowerBound().toString();
                }
                if (restriction.getUpperBound() == null) continue;
                return restriction.getLowerBound().toString();
            }
        }
        return range.toString();
    }
}

