/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.maven.report;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.axway.grapes.commons.datamodel.Artifact;
import org.axway.grapes.commons.datamodel.Module;
import org.axway.grapes.maven.report.GrapesTranslator;
import org.axway.grapes.maven.resolver.ArtifactResolver;
import org.axway.grapes.maven.resolver.LicenseResolver;

public class ModuleBuilder {
    public Module getModule(MavenProject project, LicenseResolver licenseResolver, ArtifactResolver artifactResolver) throws MojoExecutionException {
        int i;
        Module module = GrapesTranslator.getGrapesModule(project);
        List<License> licenses = licenseResolver.resolve(project);
        Artifact mainArtifact = GrapesTranslator.getGrapesArtifact(project.getArtifact());
        this.addLicenses(mainArtifact, licenses);
        module.addArtifact(mainArtifact);
        if (!mainArtifact.getType().equals("pom")) {
            Artifact pomArtifact = GrapesTranslator.getGrapesArtifact(project.getModel());
            this.addLicenses(pomArtifact, licenses);
            module.addArtifact(pomArtifact);
        }
        for (i = 0; i < project.getAttachedArtifacts().size(); ++i) {
            artifactResolver.resolveArtifact(project, (org.apache.maven.artifact.Artifact)project.getAttachedArtifacts().get(i));
            Artifact attachedArtifact = GrapesTranslator.getGrapesArtifact((org.apache.maven.artifact.Artifact)project.getAttachedArtifacts().get(i));
            this.addLicenses(attachedArtifact, licenses);
            module.addArtifact(attachedArtifact);
        }
        for (i = 0; i < project.getDependencies().size(); ++i) {
            org.axway.grapes.commons.datamodel.Dependency dependency = GrapesTranslator.getGrapesDependency(artifactResolver.resolveArtifact(project, (Dependency)project.getDependencies().get(i)), ((Dependency)project.getDependencies().get(i)).getScope());
            for (License license : licenseResolver.resolve(project, dependency.getTarget().getGroupId(), dependency.getTarget().getArtifactId(), dependency.getTarget().getVersion())) {
                dependency.getTarget().addLicense(license.getName());
            }
            module.addDependency(dependency);
        }
        return module;
    }

    private void addLicenses(Artifact mainArtifact, List<License> licenses) {
        for (License license : licenses) {
            mainArtifact.addLicense(license.getName());
        }
    }
}

