/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.maven.report;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.axway.grapes.commons.datamodel.Module;
import org.axway.grapes.commons.utils.FileUtils;
import org.axway.grapes.commons.utils.JsonUtils;
import org.axway.grapes.maven.GrapesMavenPlugin;
import org.axway.grapes.maven.report.GrapesTranslator;

public class ModuleAggregator {
    private final List<MavenProject> reactorProjects;
    private final File workingFolder;

    public ModuleAggregator(List<MavenProject> reactorProjects) {
        this.workingFolder = GrapesMavenPlugin.getGrapesPluginWorkingFolder(reactorProjects.get(0));
        this.reactorProjects = reactorProjects;
    }

    public void aggregate() throws IOException, MojoExecutionException {
        Map<String, File> subModules = this.getSubModuleReports();
        for (Map.Entry<String, File> submoduleReports : subModules.entrySet()) {
            Module subModule;
            Boolean updated;
            MavenProject parentProject = this.getParentProject(submoduleReports.getKey());
            if (parentProject == null || !(updated = this.updateParent(parentProject, subModule = JsonUtils.unserializeModule((String)FileUtils.read((File)submoduleReports.getValue())))).booleanValue()) continue;
            File subModuleFile = new File(this.workingFolder, GrapesMavenPlugin.getSubModuleFileName(submoduleReports.getKey()));
            subModuleFile.delete();
        }
    }

    private Boolean updateParent(MavenProject parentProject, Module subModule) throws MojoExecutionException, IOException {
        File parentModuleFile = this.getModuleReportFile(parentProject);
        Module rootModule = GrapesMavenPlugin.getModule(this.workingFolder, "module.json");
        if (parentModuleFile.exists()) {
            String serializedParent = FileUtils.read((File)parentModuleFile);
            parentModuleFile.delete();
            Module parentModule = JsonUtils.unserializeModule((String)serializedParent);
            parentModule.addSubmodule(subModule);
            FileUtils.serialize((File)this.workingFolder, (String)JsonUtils.serialize((Object)parentModule), (String)parentModuleFile.getName());
            return true;
        }
        if (this.contains(rootModule, parentProject)) {
            Module parentModule = this.getSubModule(rootModule, parentProject);
            parentModule.addSubmodule(subModule);
            File rootModuleFile = new File(this.workingFolder, "module.json");
            rootModuleFile.delete();
            FileUtils.serialize((File)this.workingFolder, (String)JsonUtils.serialize((Object)rootModule), (String)"module.json");
            return true;
        }
        return false;
    }

    private Map<String, File> getSubModuleReports() throws IOException, MojoExecutionException {
        HashMap<String, File> subModules = new HashMap<String, File>();
        for (MavenProject project : this.reactorProjects) {
            String fileName = GrapesMavenPlugin.getSubModuleFileName(project.getBasedir().getName());
            File reportFile = new File(this.workingFolder, fileName);
            if (!reportFile.exists()) continue;
            subModules.put(project.getBasedir().getName(), reportFile);
        }
        return subModules;
    }

    private MavenProject getParentProject(String subModuleKey) {
        for (MavenProject project : this.reactorProjects) {
            for (String submodule : project.getModules()) {
                if (!submodule.equals(subModuleKey) && !submodule.endsWith(File.separator + subModuleKey)) continue;
                return project;
            }
        }
        return null;
    }

    private File getModuleReportFile(MavenProject project) {
        if (project.equals((Object)this.reactorProjects.get(0))) {
            return new File(this.workingFolder, "module.json");
        }
        return new File(this.workingFolder, GrapesMavenPlugin.getSubModuleFileName(project.getBasedir().getName()));
    }

    private Module getSubModule(Module rootModule, MavenProject parentProject) {
        String parentSubModuleName = GrapesTranslator.generateModuleName(parentProject);
        for (Module subModule : rootModule.getSubmodules()) {
            if (subModule.getName().equals(parentSubModuleName)) {
                return subModule;
            }
            Module result = this.getSubModule(subModule, parentProject);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean contains(Module rootModule, MavenProject parentProject) {
        return this.getSubModule(rootModule, parentProject) != null;
    }
}

