/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.maven.report;

import java.io.File;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.axway.grapes.commons.datamodel.Artifact;
import org.axway.grapes.commons.datamodel.DataModelFactory;
import org.axway.grapes.commons.datamodel.Dependency;
import org.axway.grapes.commons.datamodel.Module;
import org.axway.grapes.commons.exceptions.UnsupportedScopeException;
import org.axway.grapes.commons.utils.FileUtils;
import org.axway.grapes.maven.resolver.ArtifactResolver;

public class GrapesTranslator {
    private GrapesTranslator() {
    }

    public static final Module getGrapesModule(MavenProject project) {
        String moduleName = GrapesTranslator.generateModuleName(project);
        return DataModelFactory.createModule((String)moduleName, (String)project.getVersion());
    }

    public static final String generateModuleName(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        sb.append(project.getArtifact().getGroupId());
        sb.append(":");
        sb.append(project.getArtifact().getArtifactId());
        return sb.toString();
    }

    public static final Artifact getGrapesArtifact(org.apache.maven.artifact.Artifact mavenArtifact) {
        String version;
        ArtifactHandler artifactHandler = mavenArtifact.getArtifactHandler();
        String extension = mavenArtifact.getType();
        if (artifactHandler != null) {
            extension = artifactHandler.getExtension();
        }
        if ((version = mavenArtifact.getVersion()) == null && mavenArtifact.getVersionRange() != null) {
            version = ArtifactResolver.getArtifactVersion(mavenArtifact.getVersionRange());
        }
        Artifact artifact = DataModelFactory.createArtifact((String)mavenArtifact.getGroupId(), (String)mavenArtifact.getArtifactId(), (String)version, (String)mavenArtifact.getClassifier(), (String)mavenArtifact.getType(), (String)extension);
        artifact.setDownloadUrl(mavenArtifact.getDownloadUrl());
        Long artifactSize = FileUtils.getSize((File)mavenArtifact.getFile());
        if (artifactSize != null) {
            artifact.setSize(String.valueOf(artifactSize));
        }
        return artifact;
    }

    public static Artifact getGrapesArtifact(Model pomFile) {
        Artifact artifact = DataModelFactory.createArtifact((String)pomFile.getGroupId(), (String)pomFile.getArtifactId(), (String)pomFile.getVersion(), null, (String)"pom", (String)"xml");
        Long artifactSize = FileUtils.getSize((File)pomFile.getPomFile());
        if (artifactSize != null) {
            artifact.setSize(String.valueOf(artifactSize));
        }
        return artifact;
    }

    public static final Dependency getGrapesDependency(org.apache.maven.artifact.Artifact dependency, String scope) throws MojoExecutionException {
        try {
            Artifact target = GrapesTranslator.getGrapesArtifact(dependency);
            return DataModelFactory.createDependency((Artifact)target, (String)scope);
        }
        catch (UnsupportedScopeException e) {
            throw new MojoExecutionException("Failed to create the dependency" + dependency.toString(), (Exception)((Object)e));
        }
    }
}

