/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.maven;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.axway.grapes.commons.datamodel.Module;
import org.axway.grapes.maven.AbstractGrapesMojo;
import org.axway.grapes.maven.GrapesMavenPlugin;
import org.axway.grapes.utils.client.GrapesClient;

public class NotifyMojo
extends AbstractGrapesMojo {
    private String host;
    private String port;
    private String user;
    private String password;

    public void execute() throws MojoExecutionException {
        if (this.project.equals(this.reactorProjects.get(0))) {
            try {
                File workingFolder = GrapesMavenPlugin.getGrapesPluginWorkingFolder((MavenProject)this.reactorProjects.get(0));
                Module rootModule = GrapesMavenPlugin.getModule(workingFolder, "module.json");
                this.getLog().info((CharSequence)("Sending " + rootModule.getName() + "..."));
                this.getLog().info((CharSequence)"Connection to Grapes");
                this.getLog().info((CharSequence)("Host: " + this.host));
                this.getLog().info((CharSequence)("Port: " + this.port));
                this.getLog().info((CharSequence)("User: " + this.user));
                GrapesClient client = new GrapesClient(this.host, this.port);
                if (!client.isServerAvailable()) {
                    throw new MojoExecutionException("Grapes is unreachable");
                }
                client.postModule(rootModule, this.user, this.password);
                this.getLog().info((CharSequence)"Information successfully sent");
            }
            catch (Exception e) {
                if (this.failOnError) {
                    throw new MojoExecutionException("An error occurred during Grapes server Notification.", e);
                }
                this.getLog().debug((CharSequence)"An error occurred during Grapes server Notification.", (Throwable)e);
                this.getLog().info((CharSequence)"Failed to send information to Grapes");
            }
        }
    }
}

