/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.maven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.axway.grapes.commons.datamodel.Module;
import org.axway.grapes.commons.utils.FileUtils;
import org.axway.grapes.commons.utils.JsonUtils;

public class GrapesMavenPlugin {
    public static final String MODULE_JSON_FILE_NAME = "module.json";
    public static final String TMP_MODULE_FILE_SUFFIX = "_tmp.json";

    private GrapesMavenPlugin() {
    }

    public static File getGrapesPluginWorkingFolder(MavenProject rootProject) {
        return new File(rootProject.getBuild().getDirectory() + "/grapes");
    }

    public static String getSubModuleFileName(String subModuleName) {
        return subModuleName + TMP_MODULE_FILE_SUFFIX;
    }

    public static Module getModule(File folder, String moduleJsonFileName) throws MojoExecutionException, IOException {
        File moduleFile = new File(folder, moduleJsonFileName);
        if (moduleFile.exists()) {
            String serializedModule = FileUtils.read((File)moduleFile);
            return JsonUtils.unserializeModule((String)serializedModule);
        }
        return null;
    }
}

