/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.maven;

import java.io.File;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.axway.grapes.commons.datamodel.Module;
import org.axway.grapes.commons.utils.FileUtils;
import org.axway.grapes.commons.utils.JsonUtils;
import org.axway.grapes.maven.AbstractGrapesMojo;
import org.axway.grapes.maven.GrapesMavenPlugin;
import org.axway.grapes.maven.report.ModuleAggregator;
import org.axway.grapes.maven.report.ModuleBuilder;
import org.axway.grapes.maven.resolver.ArtifactResolver;
import org.axway.grapes.maven.resolver.LicenseResolver;

public class GenerateMojo
extends AbstractGrapesMojo {
    private RepositorySystem repositorySystem;
    private ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException {
        try {
            ModuleAggregator aggregator = new ModuleAggregator(this.reactorProjects);
            ModuleBuilder moduleBuilder = new ModuleBuilder();
            ArtifactResolver artifactResolver = new ArtifactResolver(this.repositorySystem, this.localRepository, this.getLog());
            LicenseResolver licenseResolver = new LicenseResolver(this.repositorySystem, this.localRepository, this.getLog());
            this.getLog().info((CharSequence)("Collecting dependency information of " + this.project.getName()));
            Module module = moduleBuilder.getModule(this.project, licenseResolver, artifactResolver);
            String serializedModule = JsonUtils.serialize((Object)module);
            this.getLog().debug((CharSequence)("Json module : " + serializedModule));
            File grapesFolder = GrapesMavenPlugin.getGrapesPluginWorkingFolder((MavenProject)this.reactorProjects.get(0));
            this.getLog().info((CharSequence)("Serializing the notification in " + grapesFolder.getPath()));
            if (this.project.equals(this.reactorProjects.get(0))) {
                FileUtils.serialize((File)grapesFolder, (String)serializedModule, (String)"module.json");
            } else {
                String subModuleName = this.project.getBasedir().getName();
                FileUtils.serialize((File)grapesFolder, (String)serializedModule, (String)GrapesMavenPlugin.getSubModuleFileName(subModuleName));
            }
            this.getLog().info((CharSequence)"Report consolidation...");
            aggregator.aggregate();
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new MojoExecutionException("An error occurred during Grapes reporting.", e);
            }
            this.getLog().debug((CharSequence)"An error occurred during Grapes reporting.", (Throwable)e);
            this.getLog().error((CharSequence)"Failed to build Grapes report.");
        }
    }
}

