/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.commons.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.axway.grapes.commons.datamodel.Artifact;
import org.axway.grapes.commons.datamodel.Dependency;
import org.axway.grapes.commons.datamodel.Module;

public final class ModuleUtils {
    private ModuleUtils() {
    }

    public static List<Artifact> getAllArtifacts(Module module) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Module subModule : module.getSubmodules()) {
            artifacts.addAll(ModuleUtils.getAllArtifacts(subModule));
        }
        artifacts.addAll(module.getArtifacts());
        return artifacts;
    }

    public static List<Dependency> getAllDependencies(Module module) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        ArrayList<String> producedArtifacts = new ArrayList<String>();
        for (Artifact artifact : ModuleUtils.getAllArtifacts(module)) {
            producedArtifacts.add(artifact.getGavc());
        }
        dependencies.addAll(ModuleUtils.getAllDependencies(module, producedArtifacts));
        return new ArrayList<Dependency>(dependencies);
    }

    public static Set<Dependency> getAllDependencies(Module module, List<String> producedArtifacts) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        for (Dependency dependency : module.getDependencies()) {
            if (producedArtifacts.contains(dependency.getTarget().getGavc())) continue;
            dependencies.add(dependency);
        }
        for (Module subModule : module.getSubmodules()) {
            dependencies.addAll(ModuleUtils.getAllDependencies(subModule, producedArtifacts));
        }
        return dependencies;
    }

    public static List<Dependency> getCorporateDependencies(Module module, List<String> corporateFilters) {
        ArrayList<Dependency> corporateDependencies = new ArrayList<Dependency>();
        Pattern corporatePattern = ModuleUtils.generateCorporatePattern(corporateFilters);
        for (Dependency dependency : ModuleUtils.getAllDependencies(module)) {
            if (!dependency.getTarget().getGavc().matches(corporatePattern.pattern())) continue;
            corporateDependencies.add(dependency);
        }
        return corporateDependencies;
    }

    public static List<Dependency> getThirdPartyLibraries(Module module, List<String> corporateFilters) {
        ArrayList<Dependency> thirdParty = new ArrayList<Dependency>();
        Pattern corporatePattern = ModuleUtils.generateCorporatePattern(corporateFilters);
        for (Dependency dependency : ModuleUtils.getAllDependencies(module)) {
            if (dependency.getTarget().getGavc().matches(corporatePattern.pattern())) continue;
            thirdParty.add(dependency);
        }
        return thirdParty;
    }

    private static Pattern generateCorporatePattern(List<String> corporateFilters) {
        StringBuilder sb = new StringBuilder();
        if (!corporateFilters.isEmpty()) {
            sb.append("^(");
            Iterator<String> filters = corporateFilters.iterator();
            while (filters.hasNext()) {
                sb.append(filters.next());
                if (!filters.hasNext()) continue;
                sb.append("|");
            }
            sb.append(")");
        }
        sb.append("(.*)");
        return Pattern.compile(sb.toString());
    }
}

