/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.handler.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.awsutils.common.ratelimiter.RateLimiter;
import org.awsutils.sqs.aspects.SqsMessageSenderInjector;
import org.awsutils.sqs.aspects.SqsMessageSenderInjectorImpl;
import org.awsutils.sqs.client.SqsMessageClient;
import org.awsutils.sqs.handler.impl.AbstractSqsMessageHandler;

public final class MethodLevelSqsMessageHandler<T>
extends AbstractSqsMessageHandler<T>
implements SqsMessageSenderInjector {
    private final Method method;
    private final Object handlerBean;
    private /* synthetic */ SqsMessageSenderInjector ajc$instance$org_awsutils_sqs_aspects_MessageHandlerAspect$org_awsutils_sqs_aspects_SqsMessageSenderInjector;

    public <X> MethodLevelSqsMessageHandler(String sqsMessage, String transactionId, Class parameterType, Method handlerMethod, X bean, String receiptHandle, String queueUrl, Integer retryCount, Map<String, String> messageAttributes, RateLimiter messageHandlerRateLimiter) {
        this.method = handlerMethod;
        this.handlerBean = bean;
        this.initializeForMethodLevelHandler(sqsMessage, transactionId, parameterType, handlerMethod, receiptHandle, queueUrl, retryCount, messageAttributes, messageHandlerRateLimiter);
    }

    @Override
    public CompletableFuture<?> execute(T message) {
        try {
            Object returnVal = this.method.invoke(this.handlerBean, message);
            if (returnVal instanceof CompletableFuture) {
                return (CompletableFuture)returnVal;
            }
            return CompletableFuture.completedFuture(returnVal);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            RuntimeException ex;
            Throwable throwable = e.getCause();
            throw throwable instanceof RuntimeException ? (ex = (RuntimeException)throwable) : new RuntimeException(e);
        }
    }

    public void initializeForMethodLevelHandler(String sqsMessage, String transactionId, Class<T> messageTypeClass, Method method, String receiptHandle, String queueUrl, Integer retryNumber, Map<String, String> messageAttributes, RateLimiter rateLimiter) {
        super.initialize(sqsMessage, transactionId, messageTypeClass, method, receiptHandle, queueUrl, retryNumber, messageAttributes, rateLimiter);
    }

    @Override
    Class<T> getParameterType() {
        return this.method.getParameterTypes()[1];
    }

    @Override
    public SqsMessageClient sqsMessageClient() {
        if (this.ajc$instance$org_awsutils_sqs_aspects_MessageHandlerAspect$org_awsutils_sqs_aspects_SqsMessageSenderInjector == null) {
            this.ajc$instance$org_awsutils_sqs_aspects_MessageHandlerAspect$org_awsutils_sqs_aspects_SqsMessageSenderInjector = new SqsMessageSenderInjectorImpl();
        }
        return this.ajc$instance$org_awsutils_sqs_aspects_MessageHandlerAspect$org_awsutils_sqs_aspects_SqsMessageSenderInjector.sqsMessageClient();
    }
}

