/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.client;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.awsutils.sqs.message.SqsBatchMessage;
import org.awsutils.sqs.message.SqsMessage;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public interface SqsMessageClient {
    default public <T> CompletableFuture<SendMessageResponse> sendMessage(T message, String messageType, String transactionId, String queueName) {
        return this.sendMessage(message, messageType, transactionId, queueName, (Integer)BigInteger.ZERO.intValue(), Collections.emptyMap());
    }

    default public <T> CompletableFuture<SendMessageResponse> sendMessage(SqsMessage<T> sqsMessage, String queueName) {
        return this.sendMessage(sqsMessage, queueName, (Integer)BigInteger.ZERO.intValue(), Collections.emptyMap());
    }

    default public <T> CompletableFuture<SendMessageResponse> sendMessage(T message, String messageType, String transactionId, String queueName, Integer delayInSeconds) {
        return this.sendMessage(message, messageType, transactionId, queueName, delayInSeconds, Collections.emptyMap());
    }

    default public <T> CompletableFuture<SendMessageResponse> sendMessage(SqsMessage<T> sqsMessage, String queueName, Integer delayInSeconds) {
        return this.sendMessage(sqsMessage, queueName, delayInSeconds, Collections.emptyMap());
    }

    default public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<T> message, String messageType, String transactionId, String queueName) {
        return this.sendMessage(message, messageType, transactionId, queueName, (Integer)BigInteger.ZERO.intValue());
    }

    default public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(SqsBatchMessage<T> sqsBatchMessage, String queueName) {
        return this.sendMessage(sqsBatchMessage, queueName, (Integer)BigInteger.ZERO.intValue());
    }

    default public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<T> message, String messageType, String transactionId, String queueName, Integer delayInSeconds) {
        return this.sendMessage(message, messageType, transactionId, queueName, delayInSeconds, Collections.emptyMap());
    }

    default public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(SqsBatchMessage<T> sqsBatchMessage, String queueName, Integer delayInSeconds) {
        return this.sendMessage(sqsBatchMessage, queueName, delayInSeconds, Collections.emptyMap());
    }

    default public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<SqsMessage<T>> sqsMessages, String queueName) {
        return this.sendMessage(sqsMessages, queueName, (Integer)0);
    }

    default public <T> SendMessageResponse sendMessageSync(T message, String messageType, String transactionId, String queueName) {
        return this.sendMessageSync(message, messageType, transactionId, queueName, (Integer)BigInteger.ZERO.intValue(), Collections.emptyMap());
    }

    default public <T> SendMessageResponse sendMessageSync(SqsMessage<T> sqsMessage, String queueName) {
        return this.sendMessageSync(sqsMessage, queueName, (Integer)BigInteger.ZERO.intValue(), Collections.emptyMap());
    }

    default public <T> SendMessageResponse sendMessageSync(T message, String messageType, String transactionId, String queueName, Integer delayInSeconds) {
        return this.sendMessageSync(message, messageType, transactionId, queueName, delayInSeconds, Collections.emptyMap());
    }

    default public <T> SendMessageResponse sendMessageSync(SqsMessage<T> sqsMessage, String queueName, Integer delayInSeconds) {
        return this.sendMessageSync(sqsMessage, queueName, delayInSeconds, Collections.emptyMap());
    }

    default public <T> SendMessageBatchResponse sendMessageSync(List<T> message, String messageType, String transactionId, String queueName) {
        return this.sendMessageSync(message, messageType, transactionId, queueName, (Integer)BigInteger.ZERO.intValue());
    }

    default public <T> SendMessageBatchResponse sendMessageSync(SqsBatchMessage<T> sqsBatchMessage, String queueName) {
        return this.sendMessageSync(sqsBatchMessage, queueName, (Integer)BigInteger.ZERO.intValue());
    }

    default public <T> SendMessageBatchResponse sendMessageSync(List<T> message, String messageType, String transactionId, String queueName, Integer delayInSeconds) {
        return this.sendMessageSync(message, messageType, transactionId, queueName, delayInSeconds, Collections.emptyMap());
    }

    default public <T> SendMessageBatchResponse sendMessageSync(SqsBatchMessage<T> sqsBatchMessage, String queueName, Integer delayInSeconds) {
        return this.sendMessageSync(sqsBatchMessage, queueName, delayInSeconds, Collections.emptyMap());
    }

    default public <T> SendMessageBatchResponse sendMessageSync(List<SqsMessage<T>> sqsMessages, String queueName) {
        return this.sendMessageSync(sqsMessages, queueName, (Integer)0);
    }

    public <T> SendMessageResponse sendMessageSync(T var1, String var2, String var3, String var4, Integer var5, Map<String, String> var6);

    public <T> CompletableFuture<SendMessageResponse> sendMessage(SqsMessage<T> var1, String var2, Integer var3, Map<String, String> var4);

    public <T> CompletableFuture<SendMessageResponse> sendMessage(T var1, String var2, String var3, String var4, Integer var5, Map<String, String> var6);

    default public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<SqsMessage<T>> sqsMessage, String queueName, Integer delayInSeconds) {
        return this.sendMessage(sqsMessage, queueName, delayInSeconds, Collections.emptyMap());
    }

    default public <T> SendMessageBatchResponse sendMessageSync(List<SqsMessage<T>> sqsMessage, String queueName, Integer delayInSeconds) {
        return this.sendMessageSync(sqsMessage, queueName, delayInSeconds, Collections.emptyMap());
    }

    public <T> SendMessageResponse sendMessageSync(SqsMessage<T> var1, String var2, Integer var3, Map<String, String> var4);

    public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<T> var1, String var2, String var3, String var4, Integer var5, Map<String, String> var6);

    public <T> SendMessageBatchResponse sendMessageSync(List<T> var1, String var2, String var3, String var4, Integer var5, Map<String, String> var6);

    public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<SqsMessage<T>> var1, String var2, Integer var3, Map<String, String> var4);

    public <T> SendMessageBatchResponse sendMessageSync(List<SqsMessage<T>> var1, String var2, Integer var3, Map<String, String> var4);

    public String getQueueUrl(String var1);

    public CompletableFuture<DeleteMessageResponse> deleteMessage(String var1, String var2);

    public DeleteMessageResponse deleteMessageSync(String var1, String var2);

    public CompletableFuture<ChangeMessageVisibilityResponse> changeVisibility(String var1, String var2, Integer var3);

    default public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(SqsBatchMessage<T> sqsBatchMessage, String queueName, Integer delayInSeconds, Map<String, String> attMap) {
        return this.sendMessage(sqsBatchMessage.sqsMessages(), queueName, delayInSeconds, attMap);
    }

    default public <T> SendMessageBatchResponse sendMessageSync(SqsBatchMessage<T> sqsBatchMessage, String queueName, Integer delayInSeconds, Map<String, String> attMap) {
        return this.sendMessageSync(sqsBatchMessage.sqsMessages(), queueName, delayInSeconds, attMap);
    }

    public ChangeMessageVisibilityResponse changeVisibilitySync(String var1, String var2, Integer var3);
}

