/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.awsutils.common.exceptions.UtilsException;
import org.awsutils.common.util.ApplicationContextUtils;
import org.awsutils.sqs.client.AsyncSnsService;
import org.awsutils.sqs.client.SyncSnsService;
import org.awsutils.sqs.message.AbstractAwsMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;
import software.amazon.awssdk.services.sns.model.PublishResponse;

@Configurable
@JsonIgnoreProperties
public class SnsMessage<T>
extends AbstractAwsMessage<T>
implements ConfigurableObject {
    @Autowired
    @Qualifier(value="asyncSnsService")
    private AsyncSnsService asyncSnsService;
    @Autowired
    @Qualifier(value="syncSnsService")
    private SyncSnsService syncSnsService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public SnsMessage(String messageType, T message) {
        super(messageType, message);
        String string = messageType;
        T t = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, t);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && this != null && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public SnsMessage(String messageType, T message, Function<Throwable, RuntimeException> exceptionFunc) {
        super(messageType, message, exceptionFunc);
        String string = messageType;
        T t = message;
        Function<Throwable, RuntimeException> function = exceptionFunc;
        Object[] objectArray = new Object[]{string, t, function};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && this != null && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public SnsMessage(String transactionId, String messageType, T message) {
        super(transactionId, messageType, message);
        String string = transactionId;
        String string2 = messageType;
        T t = message;
        Object[] objectArray = new Object[]{string, string2, t};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && this != null && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public SnsMessage(String transactionId, String messageType, T message, Function<Throwable, RuntimeException> exceptionFunc) {
        super(transactionId, messageType, message, exceptionFunc);
        String string = transactionId;
        String string2 = messageType;
        T t = message;
        Function<Throwable, RuntimeException> function = exceptionFunc;
        Object[] objectArray = new Object[]{string, string2, t, function};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && this != null && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public CompletableFuture<PublishResponse> publish(String topicArn) {
        return this.publish(topicArn, Collections.emptyMap());
    }

    public CompletableFuture<PublishResponse> publish(String topicArn, Map<String, String> attributes) {
        AsyncSnsService snsService = this.asyncSnsService != null ? this.asyncSnsService : (AsyncSnsService)ApplicationContextUtils.getInstance().getBean(AsyncSnsService.class, "asyncSnsService");
        return (CompletableFuture)snsService.publishMessage(this, topicArn, attributes);
    }

    public PublishResponse publishSync(String topicArn, Map<String, String> attributes) {
        SyncSnsService snsService = this.syncSnsService != null ? this.syncSnsService : (SyncSnsService)ApplicationContextUtils.getInstance().getBean(SyncSnsService.class, "syncSnsService");
        return (PublishResponse)snsService.publishMessage(this, topicArn, attributes);
    }

    @Override
    public String toString() {
        return "SnsMessage{} " + super.toString();
    }

    static {
        SnsMessage.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SnsMessage.java", SnsMessage.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 30);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 34);
        ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 38);
        ajc$tjp_3 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 42);
        ajc$tjp_4 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.awsutils.sqs.message.SnsMessage", "java.lang.String:java.lang.Object", "messageType:message", ""), 30);
        ajc$tjp_5 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.awsutils.sqs.message.SnsMessage", "java.lang.String:java.lang.Object:java.util.function.Function", "messageType:message:exceptionFunc", ""), 34);
        ajc$tjp_6 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.awsutils.sqs.message.SnsMessage", "java.lang.String:java.lang.String:java.lang.Object", "transactionId:messageType:message", ""), 38);
        ajc$tjp_7 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.awsutils.sqs.message.SnsMessage", "java.lang.String:java.lang.String:java.lang.Object:java.util.function.Function", "transactionId:messageType:message:exceptionFunc", ""), 42);
    }

    private static class BuilderImpl<T>
    implements Builder<T> {
        private String transactionId;
        private String messageType;
        private T message;
        private Function<Throwable, RuntimeException> exceptionFunc = cause -> new UtilsException("UNKNOWN_ERROR", cause);

        private BuilderImpl() {
        }

        @Override
        public Builder<T> transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public Builder<T> messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public Builder<T> message(T message) {
            this.message = message;
            return this;
        }

        @Override
        public Builder<T> exceptionFunc(Function<Throwable, RuntimeException> exceptionFunc) {
            this.exceptionFunc = exceptionFunc;
            return this;
        }

        @Override
        public SnsMessage<T> build() {
            return new SnsMessage<T>(this.transactionId, this.messageType, this.message, this.exceptionFunc);
        }
    }

    public static interface Builder<T> {
        public Builder<T> transactionId(String var1);

        public Builder<T> messageType(String var1);

        public Builder<T> message(T var1);

        public Builder<T> exceptionFunc(Function<Throwable, RuntimeException> var1);

        public SnsMessage<T> build();
    }
}

