/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.config;

import jakarta.annotation.PostConstruct;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.awsutils.common.exceptions.UtilsException;
import org.awsutils.common.ratelimiter.RateLimiter;
import org.awsutils.common.ratelimiter.RateLimiterReload;
import org.awsutils.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractLocalRateLimiter
implements RateLimiter,
RateLimiterReload {
    private final Environment environment;
    private final String rateLimiterTimeUnitKey;
    private final String rateLimiterKey;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private int maxRate;
    private com.google.common.util.concurrent.RateLimiter rateLimiter;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLocalRateLimiter.class);
    private static final long SLEEP_TIME = 10L;

    public AbstractLocalRateLimiter(String rateLimiterKey, String rateLimiterTimeUnitKey, Environment environment) {
        this.environment = environment;
        this.rateLimiterTimeUnitKey = rateLimiterTimeUnitKey;
        this.rateLimiterKey = rateLimiterKey;
    }

    public boolean hasExceededMaxRate() {
        return (Boolean)Utils.executeUsingLock((Lock)this.lock.readLock(), () -> {
            try {
                while (this.hasExceededRateLimit()) {
                }
                return false;
            }
            catch (Exception e) {
                LOGGER.warn("Exception in rate limiter: " + String.valueOf(e), (Throwable)e);
                return true;
            }
        });
    }

    private boolean hasExceededRateLimit() throws InterruptedException {
        if (this.rateLimiter != null) {
            long startTime = System.currentTimeMillis();
            boolean rateLimitExceeded = this.rateLimiter.tryAcquire(10L, TimeUnit.MILLISECONDS);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("RATE_LIMIT_CHECK_TIME_TAKEN: " + (System.currentTimeMillis() - startTime));
            }
            return !rateLimitExceeded;
        }
        Thread.sleep(10L);
        return Boolean.TRUE;
    }

    public int getMaxRate() {
        return this.maxRate;
    }

    public String getRateLimiterName() {
        return this.rateLimiterKey;
    }

    @PostConstruct
    public AbstractLocalRateLimiter init() {
        this.createRateLimiter(Integer.parseInt(this.environment.getProperty(this.rateLimiterKey, "25")), TimeUnit.valueOf(this.environment.getProperty(this.rateLimiterTimeUnitKey, TimeUnit.SECONDS.name())));
        return this;
    }

    private void createRateLimiter(int rateLimit, TimeUnit timeUnit) {
        long time = timeUnit.toSeconds(1L);
        int rate = (int)((long)rateLimit / time);
        if (rate < 1) {
            throw new UtilsException("Rate cannot be lower than 0 per second");
        }
        this.maxRate = rate;
        this.rateLimiter = com.google.common.util.concurrent.RateLimiter.create((double)rate);
    }

    public void refreshIfRateChanged() {
        int configuredMaxRate = Integer.parseInt(this.environment.getProperty(this.rateLimiterKey, "25"));
        TimeUnit timeUnit = TimeUnit.valueOf(this.environment.getProperty(this.rateLimiterTimeUnitKey, TimeUnit.SECONDS.name()));
        if (configuredMaxRate != this.maxRate && configuredMaxRate > 0) {
            Utils.executeUsingLock((Lock)this.lock.writeLock(), () -> {
                if (configuredMaxRate != this.maxRate) {
                    this.createRateLimiter(configuredMaxRate, timeUnit);
                }
            });
        }
    }
}

