/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.client;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.awsutils.common.util.Utils;
import org.awsutils.sqs.client.SqsMessageClient;
import org.awsutils.sqs.message.AbstractAwsMessage;
import org.awsutils.sqs.message.SqsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractSqsMessageClient<SEND_MSG_RESP_TYPE, SEND_BATCH_MSG_RESP_TYPE, DELETE_MSG_RESP_TYPE, CHANGE_VSB_RESP_TYPE>
implements SqsMessageClient<SEND_MSG_RESP_TYPE, SEND_BATCH_MSG_RESP_TYPE, DELETE_MSG_RESP_TYPE, CHANGE_VSB_RESP_TYPE> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSqsMessageClient.class);
    private final ConcurrentHashMap<String, String> queueUrlMap = new ConcurrentHashMap();

    AbstractSqsMessageClient() {
    }

    <T> SendMessageRequest.Builder getSendMessageRequestBuilder(T sqsMessage, String messageType, String transactionId, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap) {
        String str;
        String finalMessage = sqsMessage instanceof String ? (str = (String)sqsMessage) : Utils.constructJson(sqsMessage);
        SendMessageRequest.Builder sendMessageRequestBuilder = SendMessageRequest.builder().messageBody(finalMessage).delaySeconds(delayInSeconds).queueUrl(this.getQueueUrl(queueName));
        HashMap<String, String> finalMessageAttributes = !CollectionUtils.isEmpty(messageAttMap) ? new HashMap<String, String>(messageAttMap) : new HashMap();
        finalMessageAttributes.put("sqsMessageWrapperPresent", "false");
        sendMessageRequestBuilder.messageAttributes(this.getSqsMessageAttributeValues(messageType, transactionId, this.getSqsMessageAttributes(finalMessageAttributes)));
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("Sending message to SQS [{0}]: {1}", this.getQueueUrl(queueName), sqsMessage));
        }
        return sendMessageRequestBuilder;
    }

    <T> SEND_BATCH_MSG_RESP_TYPE validateAndSendMessage(List<T> sqsMessages, Supplier<SEND_BATCH_MSG_RESP_TYPE> supplier) {
        if (!CollectionUtils.isEmpty(sqsMessages) && sqsMessages.size() <= 10) {
            return supplier.get();
        }
        log.error(CollectionUtils.isEmpty(sqsMessages) ? "At least one message needs to be sent" : "Maximum number of messages supported is 10");
        throw new IllegalArgumentException(CollectionUtils.isEmpty(sqsMessages) ? "At least one message needs to be sent" : "Maximum number of messages supported is 10");
    }

    <T> SEND_BATCH_MSG_RESP_TYPE sendMessage(List<SqsMessage<T>> sqsMessages, String queueName, Integer delayInSeconds, Map<String, String> attMap, Function<SendMessageBatchRequest, SEND_BATCH_MSG_RESP_TYPE> function) {
        return (SEND_BATCH_MSG_RESP_TYPE)this.validateAndSendMessage(sqsMessages, () -> {
            Map<String, MessageAttributeValue> attributeValueMap = this.getSqsMessageAttributes(this.constructFinalMessageAttributeMap((SqsMessage)sqsMessages.get(0), attMap));
            String queueUrl = this.getQueueUrl(queueName);
            Set uniqueTransactionIds = sqsMessages.stream().map(AbstractAwsMessage::getTransactionId).filter(StringUtils::hasLength).collect(Collectors.toSet());
            boolean areTransactionIdsUnique = !CollectionUtils.isEmpty(uniqueTransactionIds) && uniqueTransactionIds.size() == sqsMessages.size();
            SendMessageBatchRequest request = (SendMessageBatchRequest)SendMessageBatchRequest.builder().entries((Collection)sqsMessages.stream().map(sqsMessage -> (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(areTransactionIdsUnique ? sqsMessage.getTransactionId() : UUID.randomUUID().toString()).messageBody(Utils.constructJson((Object)sqsMessage)).delaySeconds(delayInSeconds).messageAttributes(this.getSqsMessageAttributeValues((SqsMessage)sqsMessage, attributeValueMap)).build()).collect(Collectors.toList())).queueUrl(queueUrl).build();
            if (log.isDebugEnabled()) {
                log.debug(MessageFormat.format("Sending messages to SQS[{0}] : {1}", queueUrl, sqsMessages));
            }
            return function.apply(request);
        });
    }

    protected <T> SEND_MSG_RESP_TYPE sendSingleMessage(SqsMessage<T> sqsMessage, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap, Function<SendMessageRequest, SEND_MSG_RESP_TYPE> function) {
        return function.apply((SendMessageRequest)this.getSendMessageRequestBuilder(sqsMessage, queueName, delayInSeconds, messageAttMap).build());
    }

    protected <T> SEND_MSG_RESP_TYPE sendSingleMessage(T sqsMessage, String messageType, String transactionId, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap, Function<SendMessageRequest, SEND_MSG_RESP_TYPE> function) {
        return function.apply((SendMessageRequest)this.getSendMessageRequestBuilder(sqsMessage, messageType, transactionId, queueName, delayInSeconds, messageAttMap).build());
    }

    private <T> SendMessageRequest.Builder getSendMessageRequestBuilder(SqsMessage<T> sqsMessage, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap) {
        SendMessageRequest.Builder sendMessageRequestBuilder = SendMessageRequest.builder().messageBody(Utils.constructJson(sqsMessage)).delaySeconds(delayInSeconds).queueUrl(this.getQueueUrl(queueName));
        HashMap<String, String> finalMessageAttributes = !CollectionUtils.isEmpty(messageAttMap) ? new HashMap<String, String>(messageAttMap) : new HashMap();
        finalMessageAttributes.put("sqsMessageWrapperPresent", "true");
        sendMessageRequestBuilder.messageAttributes(this.getSqsMessageAttributeValues(sqsMessage, this.getSqsMessageAttributes(finalMessageAttributes)));
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("Sending message to SQS [{0}]: {1}", this.getQueueUrl(queueName), sqsMessage));
        }
        return sendMessageRequestBuilder;
    }

    private <T> Map<String, MessageAttributeValue> getSqsMessageAttributeValues(SqsMessage<T> sqsMessage, Map<String, MessageAttributeValue> attributeValueMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(attributeValueMap);
        if (StringUtils.hasLength((String)sqsMessage.getTransactionId())) {
            builder.put((Object)"transactionId", (Object)((MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(sqsMessage.getTransactionId()).build()));
        }
        builder.put((Object)"messageType", (Object)((MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(sqsMessage.getMessageType()).build()));
        return builder.build();
    }

    private Map<String, MessageAttributeValue> getSqsMessageAttributeValues(String messageType, String transactionId, Map<String, MessageAttributeValue> attributeValueMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(attributeValueMap);
        if (StringUtils.hasLength((String)transactionId)) {
            builder.put((Object)"transactionId", (Object)((MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(transactionId).build()));
        }
        builder.put((Object)"messageType", (Object)((MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(messageType).build()));
        return builder.build();
    }

    private Map<String, MessageAttributeValue> getSqsMessageAttributes(Map<String, String> attMap) {
        return !CollectionUtils.isEmpty(attMap) ? ImmutableMap.copyOf(attMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, b -> (MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue((String)b.getValue()).build()))) : Collections.emptyMap();
    }

    <T> Map<String, String> constructFinalMessageAttributeMap(SqsMessage<T> sqsMessage, Map<String, String> messageAttMap) {
        HashMap<String, String> finalMessageAttributes = !CollectionUtils.isEmpty(messageAttMap) ? new HashMap<String, String>(messageAttMap) : new HashMap();
        finalMessageAttributes.put("sqsMessageWrapperPresent", "true");
        return finalMessageAttributes;
    }

    private Map<String, String> constructFinalMessageAttributeMap(String transactionId, String messageType, Map<String, String> messageAttMap) {
        HashMap<String, String> finalMessageAttributes = !CollectionUtils.isEmpty(messageAttMap) ? new HashMap<String, String>(messageAttMap) : new HashMap();
        finalMessageAttributes.put("sqsMessageWrapperPresent", "false");
        return finalMessageAttributes;
    }

    protected <T> SEND_BATCH_MSG_RESP_TYPE sendMessage(List<T> sqsMessages, String messageType, String transactionId, String queueName, Integer delayInSeconds, Map<String, String> attMap, Function<SendMessageBatchRequest, SEND_BATCH_MSG_RESP_TYPE> function) {
        return (SEND_BATCH_MSG_RESP_TYPE)this.validateAndSendMessage(sqsMessages, () -> {
            Map<String, MessageAttributeValue> attributeValueMap = this.getSqsMessageAttributes(this.constructFinalMessageAttributeMap(transactionId, messageType, attMap));
            String queueUrl = this.getQueueUrl(queueName);
            SendMessageBatchRequest request = (SendMessageBatchRequest)SendMessageBatchRequest.builder().entries((Collection)sqsMessages.stream().map(sqsMessage -> (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(StringUtils.hasLength((String)transactionId) ? transactionId : UUID.randomUUID().toString()).messageBody(Utils.constructJson((Object)sqsMessage)).delaySeconds(delayInSeconds).messageAttributes(this.getSqsMessageAttributeValues(messageType, transactionId, attributeValueMap)).build()).collect(Collectors.toList())).queueUrl(queueUrl).build();
            if (log.isDebugEnabled()) {
                log.debug(MessageFormat.format("Sending messages to SQS[{0}] : {1}", queueUrl, sqsMessages));
            }
            return function.apply(request);
        });
    }

    protected DELETE_MSG_RESP_TYPE deleteMessage(String queueUrl, String receiptHandle, Function<DeleteMessageRequest, DELETE_MSG_RESP_TYPE> function) {
        DeleteMessageRequest deleteMessageRequest = (DeleteMessageRequest)DeleteMessageRequest.builder().queueUrl(queueUrl).receiptHandle(receiptHandle).build();
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Deleting message  from Queue: {0} with receiptHandle: {1}", queueUrl, receiptHandle));
        }
        return function.apply(deleteMessageRequest);
    }

    protected CHANGE_VSB_RESP_TYPE changeVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout, Function<ChangeMessageVisibilityRequest, CHANGE_VSB_RESP_TYPE> function) {
        ChangeMessageVisibilityRequest request = (ChangeMessageVisibilityRequest)ChangeMessageVisibilityRequest.builder().queueUrl(queueUrl).receiptHandle(receiptHandle).visibilityTimeout(visibilityTimeout).build();
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Changing visibility of [{0}] from queue: {1}", receiptHandle, queueUrl));
        }
        return function.apply(request);
    }

    protected <T> SendMessageResponse logSqsSendResponse(SqsMessage<T> sqsMessage, String queueName, Integer delayInSeconds, SendMessageResponse response) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Sent message to {0}, message type: {1} w/ delay {2}", queueName, sqsMessage.getMessageType(), delayInSeconds));
        }
        return response;
    }

    protected <T> SendMessageResponse logSqsSendResponse(T sqsMessage, String messageType, String queueName, Integer delayInSeconds, SendMessageResponse response) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Sent message to {0}, message type: {1} w/ delay {2}", queueName, messageType, delayInSeconds));
        }
        return response;
    }

    @Override
    public String getQueueUrl(String queueName) {
        return this.queueUrlMap.computeIfAbsent(queueName, s -> this.queueUrl(queueName));
    }

    protected abstract String queueUrl(String var1);
}

