/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.message;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.awsutils.common.util.Utils;
import org.awsutils.sqs.message.AwsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAwsMessage<T>
implements AwsMessage {
    private final String transactionId;
    private final String messageType;
    private final Map<String, ?> message;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAwsMessage.class);
    private static Class<? extends Enum<?>> messageEnumType;

    AbstractAwsMessage(String messageType, T message) {
        this(messageType, message, RuntimeException::new);
    }

    AbstractAwsMessage(String messageType, T message, Function<Throwable, RuntimeException> exceptionFunc) {
        this(UUID.randomUUID().toString(), messageType, message, exceptionFunc);
    }

    AbstractAwsMessage(String transactionId, String messageType, T message) {
        this(transactionId, messageType, message, RuntimeException::new);
    }

    AbstractAwsMessage(String transactionId, String messageType, T message, Function<Throwable, RuntimeException> exceptionFunc) {
        this.transactionId = transactionId;
        this.messageType = messageType;
        this.message = (Map)Utils.constructFromJson(HashMap.class, (String)Utils.constructJson(message), exceptionFunc);
        if (messageEnumType != null) {
            this.validateMessageType();
        }
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    @Override
    public Map<String, ?> getMessage() {
        return this.message;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    public static void messageEnumType(Class<? extends Enum<?>> validationEnum) {
        messageEnumType = validationEnum;
    }

    private void validateMessageType() {
        try {
            LOGGER.debug("Sqs Message Type: " + Enum.valueOf(messageEnumType, this.messageType));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(MessageFormat.format("The messageType [{0}] does not match any constant defined in the Enum [{1}]", this.messageType, messageEnumType.getSimpleName()), (Throwable)e);
            throw e;
        }
    }

    public String toString() {
        return "AbstractAwsMessage{transactionId='" + this.transactionId + "', messageType='" + this.messageType + "', message=" + this.message + "}";
    }

    static abstract class BuilderImpl<T, A extends AbstractAwsMessage<T>>
    implements Builder<T, A> {
        protected String transactionId;
        protected String messageType;
        protected T message;
        protected Function<Throwable, RuntimeException> exceptionFunc;

        BuilderImpl() {
        }

        @Override
        public <X extends Builder<T, A>> X transactionId(String transactionId) {
            this.transactionId = transactionId;
            return (X)this;
        }

        @Override
        public <X extends Builder<T, A>> X messageType(String messageType) {
            this.messageType = messageType;
            return (X)this;
        }

        @Override
        public <X extends Builder<T, A>> X message(T message) {
            this.message = message;
            return (X)this;
        }

        @Override
        public <X extends Builder<T, A>> X exceptionFunc(Function<Throwable, RuntimeException> exceptionFunc) {
            this.exceptionFunc = exceptionFunc;
            return (X)this;
        }
    }

    public static interface Builder<T, A extends AbstractAwsMessage<T>> {
        public <X extends Builder<T, A>> X transactionId(String var1);

        public <X extends Builder<T, A>> X messageType(String var1);

        public <X extends Builder<T, A>> X message(T var1);

        public <X extends Builder<T, A>> X exceptionFunc(Function<Throwable, RuntimeException> var1);

        public A build();
    }
}

