/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.handler.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.awsutils.common.exceptions.ServiceException;
import org.awsutils.common.ratelimiter.RateLimiter;
import org.awsutils.common.util.Utils;
import org.awsutils.sqs.annotations.MessageHandler;
import org.awsutils.sqs.aspects.SqsMessageSenderInjector;
import org.awsutils.sqs.aspects.SqsMessageSenderInjectorImpl;
import org.awsutils.sqs.client.SyncSqsMessageClient;
import org.awsutils.sqs.handler.SqsMessageHandler;
import org.awsutils.sqs.message.SqsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import software.amazon.awssdk.utils.StringUtils;

public abstract class AbstractSqsMessageHandler<T>
implements SqsMessageHandler<T>,
SqsMessageSenderInjector {
    private T message;
    private String receiptHandle;
    private String queueUrl;
    private Integer retryNumber;
    private Set<String> skipRetryForErrorTypes;
    private Set<Class<? extends Exception>> skipRetryForErrorTypesExceptions;
    private Map<String, String> messageAttributes;
    private RateLimiter rateLimiter;
    private static final int TIME_TO_PROCESS_MESSAGE_SECONDS = (int)TimeUnit.MINUTES.toSeconds(15L);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSqsMessageHandler.class);
    private String transactionId;
    private /* synthetic */ SqsMessageSenderInjector ajc$instance$org_awsutils_sqs_aspects_MessageHandlerAspect$org_awsutils_sqs_aspects_SqsMessageSenderInjector;

    @Override
    public void handle() {
        try {
            if (!StringUtils.isEmpty((CharSequence)this.transactionId)) {
                Utils.executeWithTransactionId(this::processFunction, (String)this.transactionId);
            } else {
                this.processFunction();
            }
        }
        finally {
            MDC.clear();
        }
    }

    @Override
    public void handleException(T message, Throwable exception) {
        if (this.skipChangeVisibility(exception)) {
            LOGGER.warn("Exception received. Not retrying since error type is " + exception);
        } else {
            this.changeVisibility(exception);
        }
    }

    private void changeVisibility(Throwable ex) {
        if (ex != null) {
            LOGGER.warn("Changing visibility due to error: " + ex);
        }
        int visibilityTimeout = this.getVisibilityTimeout();
        this.changeVisibility(visibilityTimeout);
    }

    int getVisibilityTimeout() {
        return Utils.calculateVisibilityTimeout((int)this.getRetryNumber());
    }

    @Override
    public T getMessage() {
        return this.message;
    }

    @Override
    public void handleSuccess() {
        this.deleteMessage();
    }

    void deleteMessage() {
        SqsMessageSenderInjector injector = this;
        SyncSqsMessageClient sqsMessageClient = injector.sqsMessageClient();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("deleting message from SQS queue: {}, Message: {}", (Object)this.receiptHandle, this.message);
        }
        if (sqsMessageClient != null) {
            sqsMessageClient.deleteMessage(this.queueUrl, this.receiptHandle);
        }
    }

    private void processFunction() {
        Runnable processFunc = () -> {
            T message = this.getMessage();
            try {
                Object executionResult;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("In handle method of " + this);
                }
                this.changeVisibility(TIME_TO_PROCESS_MESSAGE_SECONDS);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Calling execute...");
                }
                if ((executionResult = this.execute(message)) instanceof CompletableFuture) {
                    CompletableFuture future = (CompletableFuture)executionResult;
                    ((CompletableFuture)future.whenComplete((result, e) -> this.handleSqsMessageProcessResult(result, (Throwable)e, message))).exceptionallyAsync(e -> {
                        this.handleException(message, (Throwable)e);
                        return null;
                    });
                } else {
                    this.handleSqsMessageProcessResult(executionResult, null, message);
                }
            }
            catch (Exception e2) {
                LOGGER.error("Exception while handling Sqs Message: [" + this.getClass() + "]: " + e2, (Throwable)e2);
                this.handleException(message, e2);
            }
        };
        if (this.rateLimiter != null) {
            this.rateLimiter.execute(processFunc);
        } else {
            processFunc.run();
        }
    }

    private void handleSqsMessageProcessResult(Object result, Throwable e, T message) {
        if (result != null) {
            this.handleSuccess();
        } else if (e != null) {
            this.handleException(message, e);
        } else {
            this.handleSuccess();
        }
    }

    private void changeVisibility(int visibilityTimeout) {
        SqsMessageSenderInjector injector = this;
        SyncSqsMessageClient sqsMessageClient = injector.sqsMessageClient();
        if (sqsMessageClient != null) {
            sqsMessageClient.changeVisibility(this.queueUrl, this.receiptHandle, visibilityTimeout);
        }
    }

    private boolean isExceptionInstance(Class<?> exceptionClass, Class<? extends Exception> e) {
        if (exceptionClass != Object.class && exceptionClass == e) {
            return true;
        }
        if (exceptionClass != Object.class && exceptionClass != e) {
            return this.isExceptionInstance(exceptionClass.getSuperclass(), e);
        }
        return false;
    }

    T validateAndReturn(T message) {
        return message;
    }

    public int getRetryNumber() {
        return this.retryNumber != null ? this.retryNumber : 0;
    }

    protected Map<String, String> getMessageAttributes() {
        return this.messageAttributes;
    }

    protected String getMessageAttribute(String key) {
        return this.messageAttributes.entrySet().stream().filter(entry -> key.equalsIgnoreCase((String)entry.getKey())).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new ServiceException("NO_SUCH_ATTRIBUTE_PRESENT", "NO_SUCH_ATTRIBUTE_PRESENT"));
    }

    private boolean skipChangeVisibility(Throwable exception) {
        return exception instanceof ServiceException && this.skipRetryForErrorTypes.contains(((ServiceException)exception).getErrorType()) || this.skipRetryForErrorTypesExceptions.stream().anyMatch(e -> this.isExceptionInstance(exception.getClass(), (Class<? extends Exception>)e));
    }

    private void initialize(SqsMessage<T> sqsMessage, String receiptHandle, String queueUrl, Integer retryNumber, Map<String, String> messageAttributes, RateLimiter rateLimiter) {
        this.message = this.validateAndReturn(Utils.constructFromJson(this.getParameterType(), (String)Utils.constructJson(sqsMessage.getMessage()), cause -> new ServiceException("UNKNOWN_ERROR", cause)));
        this.receiptHandle = receiptHandle;
        this.queueUrl = queueUrl;
        this.retryNumber = retryNumber;
        this.messageAttributes = messageAttributes;
        this.transactionId = sqsMessage.getTransactionId();
        MessageHandler messageHandler = this.getClass().getAnnotation(MessageHandler.class);
        this.skipRetryForErrorTypes = Arrays.stream(messageHandler.skipRetryFor()).collect(Collectors.toSet());
        this.skipRetryForErrorTypesExceptions = Arrays.stream(messageHandler.skipRetryForExceptions()).collect(Collectors.toSet());
        this.rateLimiter = rateLimiter;
    }

    void initialize(String sqsMessage, String transactionId, Class<T> messageTypeClass, Method method, String receiptHandle, String queueUrl, Integer retryNumber, Map<String, String> messageAttributes, RateLimiter rateLimiter) {
        this.message = this.validateAndReturn(Utils.constructFromJson(messageTypeClass, (String)sqsMessage));
        this.receiptHandle = receiptHandle;
        this.queueUrl = queueUrl;
        this.retryNumber = retryNumber;
        this.messageAttributes = messageAttributes;
        this.transactionId = transactionId;
        MessageHandler messageHandler = method.getAnnotation(MessageHandler.class);
        this.skipRetryForErrorTypes = Arrays.stream(messageHandler.skipRetryFor()).collect(Collectors.toSet());
        this.skipRetryForErrorTypesExceptions = Arrays.stream(messageHandler.skipRetryForExceptions()).collect(Collectors.toSet());
        this.rateLimiter = rateLimiter;
    }

    Class<T> getParameterType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public SyncSqsMessageClient sqsMessageClient() {
        if (this.ajc$instance$org_awsutils_sqs_aspects_MessageHandlerAspect$org_awsutils_sqs_aspects_SqsMessageSenderInjector == null) {
            this.ajc$instance$org_awsutils_sqs_aspects_MessageHandlerAspect$org_awsutils_sqs_aspects_SqsMessageSenderInjector = new SqsMessageSenderInjectorImpl();
        }
        return this.ajc$instance$org_awsutils_sqs_aspects_MessageHandlerAspect$org_awsutils_sqs_aspects_SqsMessageSenderInjector.sqsMessageClient();
    }
}

