/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.handler;

import io.vavr.Tuple2;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.awsutils.common.exceptions.UtilsException;
import org.awsutils.common.ratelimiter.RateLimiter;
import org.awsutils.common.util.ApplicationContextUtils;
import org.awsutils.common.util.Utils;
import org.awsutils.sqs.handler.MessageHandlerFactory;
import org.awsutils.sqs.handler.SqsMessageHandler;
import org.awsutils.sqs.handler.impl.AbstractSqsMessageHandler;
import org.awsutils.sqs.handler.impl.MethodLevelSqsMessageHandler;
import org.awsutils.sqs.message.SqsMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

public class MessageHandlerFactoryImpl
implements MessageHandlerFactory {
    private final Map<String, Tuple2<Constructor<AbstractSqsMessageHandler>, Method>> handlerMapping;
    private final Map<String, Method> methodHandlerMapping;
    private final ApplicationContext applicationContext;

    public MessageHandlerFactoryImpl(Map<String, Tuple2<Constructor<AbstractSqsMessageHandler>, Method>> handlerMapping, Map<String, Method> methodHandlerMapping, ApplicationContext applicationContext) {
        this.handlerMapping = handlerMapping;
        this.methodHandlerMapping = methodHandlerMapping;
        this.applicationContext = applicationContext;
    }

    @Override
    public <T> SqsMessageHandler<T> getMessageHandler(String sqsMessage, String messageType, String transactionId, String receiptHandle, String queueUrl, Integer retryCount, Map<String, String> messageAttributes, RateLimiter messageHandlerRateLimiter) {
        if (!this.methodHandlerMapping.containsKey(messageType)) {
            throw new UtilsException("NO_HANDLER_FOR_MESSAGE_TYPE", String.format("No handler for message type '%s'", messageType));
        }
        return this.getSqsMessageHandler(sqsMessage, messageType, transactionId, receiptHandle, queueUrl, retryCount, this.methodHandlerMapping.get(messageType), messageAttributes, messageHandlerRateLimiter);
    }

    @Override
    public <T> SqsMessageHandler<T> getMessageHandler(SqsMessage<T> sqsMessage, String receiptHandle, String queueUrl, Integer retryCount, Map<String, String> messageAttributes, RateLimiter messageHandlerRateLimiter) {
        if (!this.handlerMapping.containsKey(sqsMessage.getMessageType()) && !this.methodHandlerMapping.containsKey(sqsMessage.getMessageType())) {
            throw new UtilsException("NO_HANDLER_FOR_MESSAGE_TYPE", String.format("No handler for message type '%s'", sqsMessage.getMessageType()));
        }
        if (this.handlerMapping.containsKey(sqsMessage.getMessageType())) {
            return this.createSqsMessageHandlerProxy(this.getSqsMessageHandler(sqsMessage, receiptHandle, queueUrl, retryCount, this.handlerMapping.get(sqsMessage.getMessageType()), messageAttributes, messageHandlerRateLimiter));
        }
        return this.getSqsMessageHandler(Utils.constructJson(sqsMessage.getMessage()), sqsMessage.getMessageType(), sqsMessage.getTransactionId(), receiptHandle, queueUrl, retryCount, this.methodHandlerMapping.get(sqsMessage.getMessageType()), messageAttributes, messageHandlerRateLimiter);
    }

    private <T> SqsMessageHandler<T> getSqsMessageHandler(String sqsMessage, String messageType, String transactionId, String receiptHandle, String queueUrl, Integer retryCount, Method handlerMethod, Map<String, String> messageAttributes, RateLimiter messageHandlerRateLimiter) {
        MethodLevelSqsMessageHandler sqsMessageHandler = new MethodLevelSqsMessageHandler(sqsMessage, transactionId, handlerMethod.getParameterTypes()[0], handlerMethod, this.applicationContext.getBean(handlerMethod.getDeclaringClass()), receiptHandle, queueUrl, retryCount, messageAttributes, messageHandlerRateLimiter);
        sqsMessageHandler.initializeForMethodLevelHandler(sqsMessage, transactionId, handlerMethod.getParameterTypes()[0], handlerMethod, receiptHandle, queueUrl, retryCount, messageAttributes, messageHandlerRateLimiter);
        return this.createSqsMessageHandlerProxy(sqsMessageHandler);
    }

    private <T> SqsMessageHandler<T> createSqsMessageHandlerProxy(SqsMessageHandler<T> sqsMessageHandler) {
        return (SqsMessageHandler)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{SqsMessageHandler.class}, (proxy, method, args) -> method.invoke((Object)sqsMessageHandler, args));
    }

    private <T> SqsMessageHandler<T> getSqsMessageHandler(SqsMessage<T> sqsMessage, String receiptHandle, String queueUrl, Integer retryCount, Tuple2<Constructor<AbstractSqsMessageHandler>, Method> constructor, Map<String, String> messageAttributes, RateLimiter messageHandlerRateLimiter) {
        try {
            Object[] fields;
            SqsMessageHandler sqsMessageHandler = (SqsMessageHandler)((Constructor)constructor._1()).newInstance(new Object[0]);
            ((Method)constructor._2()).invoke((Object)sqsMessageHandler, sqsMessage, receiptHandle, queueUrl, retryCount, messageAttributes, messageHandlerRateLimiter);
            if (sqsMessageHandler.getClass().getAnnotation(Configurable.class) == null && !ArrayUtils.isEmpty((Object[])(fields = sqsMessageHandler.getClass().getDeclaredFields()))) {
                for (Object field : fields) {
                    ((Field)field).setAccessible(true);
                    Autowired autowired = ((Field)field).getAnnotation(Autowired.class);
                    Qualifier qualifier = ((Field)field).getAnnotation(Qualifier.class);
                    if (autowired == null) continue;
                    Object bean = qualifier == null ? ApplicationContextUtils.getInstance().getBean(((Field)field).getType()) : ApplicationContextUtils.getInstance().getBean(((Field)field).getType(), qualifier.value());
                    ((Field)field).set(sqsMessageHandler, bean);
                }
            }
            return sqsMessageHandler;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UtilsException("UNKNOWN_ERROR", String.format("Construction failed for message '%s' w/ queueUrl '%s' and retryCount '%d' using construction '%s' -- %s", sqsMessage, queueUrl, retryCount, ((Constructor)constructor._1()).getName(), sqsMessage.getMessage()), (Throwable)e);
        }
    }
}

