/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.config;

import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.awsutils.common.exceptions.UtilsException;
import org.awsutils.common.ratelimiter.RateLimiter;
import org.awsutils.common.ratelimiter.RateLimiterFactory;
import org.awsutils.common.ratelimiter.RateLimiterReload;
import org.awsutils.common.ratelimiter.RateLimiterType;
import org.awsutils.common.util.ApplicationContextUtils;
import org.awsutils.sqs.config.LocalRateLimiter;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

enum RateLimiterFactoryImpl implements RateLimiterFactory
{
    INSTANCE;

    private final ConcurrentHashMap<String, RateLimiter> localRateLimiters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RateLimiter> distributedRateLimiters = new ConcurrentHashMap();
    private static final String RATE_LIMITER_CONFIG_PREFIX = "org.awsutils.ratelimiter.config.ratelimiters.{0}.";

    public RateLimiter getRateLimiter(String name) {
        Environment environment = ApplicationContextUtils.getInstance().getEnvironment();
        String rateLimiterTypeStr = environment.getProperty(MessageFormat.format("org.awsutils.ratelimiter.config.ratelimiters.{0}.type", name));
        RateLimiterType rateLimiterType = !StringUtils.isEmpty((Object)rateLimiterTypeStr) ? RateLimiterType.valueOf((String)rateLimiterTypeStr) : RateLimiterType.LOCAL;
        return this.getRateLimiter(name, environment);
    }

    public RateLimiter getRateLimiter(String name, Environment environment) {
        String rateLimiterTypeStr = environment.getProperty(MessageFormat.format("org.awsutils.ratelimiter.config.ratelimiters.{0}.type", name));
        RateLimiterType rateLimiterType = !StringUtils.isEmpty((Object)rateLimiterTypeStr) ? RateLimiterType.valueOf((String)rateLimiterTypeStr) : RateLimiterType.LOCAL;
        Integer maxPerTimeUnit = (Integer)environment.getProperty(MessageFormat.format("org.awsutils.ratelimiter.config.ratelimiters.{0}.maxRate", name), Integer.class);
        String maxRateTimeUnitKey = MessageFormat.format("org.awsutils.ratelimiter.config.ratelimiters.{0}.maxRateTimeUnit", name);
        if (maxPerTimeUnit != null && maxPerTimeUnit < 0) {
            throw new UtilsException("Invalid maxRate value for " + name);
        }
        return this.localRateLimiters.computeIfAbsent(name, s -> this.getRateLimiterProxy(new LocalRateLimiter(MessageFormat.format("org.awsutils.ratelimiter.config.ratelimiters.{0}.maxRate", name), maxRateTimeUnitKey, environment).init()));
    }

    public RateLimiter getRateLimiterProxy(RateLimiter rateLimiter) {
        return (RateLimiter)Proxy.newProxyInstance(RateLimiterFactoryImpl.class.getClassLoader(), new Class[]{RateLimiter.class, RateLimiterReload.class}, (proxy, method, args) -> method.invoke((Object)rateLimiter, args));
    }

    public List<RateLimiterReload> getAllRateLimiters() {
        return Stream.concat(this.localRateLimiters.values().stream().map(a -> (RateLimiterReload)a), this.distributedRateLimiters.values().stream().map(b -> (RateLimiterReload)b)).collect(Collectors.toList());
    }
}

