/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.client;

import java.util.List;
import java.util.Map;
import org.awsutils.sqs.client.AbstractSqsMessageClient;
import org.awsutils.sqs.client.SyncSqsMessageClient;
import org.awsutils.sqs.message.SqsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public final class SyncSqsMessageClientImpl
extends AbstractSqsMessageClient<SendMessageResponse, SendMessageBatchResponse, DeleteMessageResponse, ChangeMessageVisibilityResponse>
implements SyncSqsMessageClient {
    private static final Logger log = LoggerFactory.getLogger(SyncSqsMessageClientImpl.class);
    private final SqsClient sqsSyncClient;

    public SyncSqsMessageClientImpl(SqsClient sqsClient) {
        this.sqsSyncClient = sqsClient;
    }

    @Override
    protected String queueUrl(String queueName) {
        GetQueueUrlRequest queueUrlRequest = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).build();
        GetQueueUrlResponse queueUrlResponse = this.sqsSyncClient.getQueueUrl(queueUrlRequest);
        return queueUrlResponse.queueUrl();
    }

    @Override
    public <T> SendMessageResponse sendMessage(SqsMessage<T> sqsMessage, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap) {
        return this.handleSqsResponse(sqsMessage, queueName, delayInSeconds, this.sqsSyncClient.sendMessage((SendMessageRequest)this.getSendMessageRequestBuilder(sqsMessage, queueName, delayInSeconds, messageAttMap).build()));
    }

    @Override
    public <T> SendMessageResponse sendMessage(T sqsMessage, String messageType, String transactionId, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap) {
        return this.handleSqsResponse(sqsMessage, messageType, queueName, delayInSeconds, this.sqsSyncClient.sendMessage((SendMessageRequest)this.getSendMessageRequestBuilder(sqsMessage, messageType, transactionId, queueName, delayInSeconds, messageAttMap).build()));
    }

    @Override
    public <T> SendMessageBatchResponse sendMessage(List<T> sqsMessages, String messageType, String transactionId, String queueName, Integer delayInSeconds, Map<String, String> attMap) {
        return this.sendMessage(sqsMessages, messageType, transactionId, queueName, delayInSeconds, attMap, arg_0 -> ((SqsClient)this.sqsSyncClient).sendMessageBatch(arg_0));
    }

    @Override
    public <T> SendMessageBatchResponse sendMessage(List<SqsMessage<T>> sqsMessages, String queueName, Integer delayInSeconds, Map<String, String> attMap) {
        return this.validateAndSendMessage(sqsMessages, () -> this.sendMessage(sqsMessages, queueName, delayInSeconds, attMap, arg_0 -> ((SqsClient)this.sqsSyncClient).sendMessageBatch(arg_0)));
    }

    @Override
    public DeleteMessageResponse deleteMessage(String queueUrl, String receiptHandle) {
        return this.deleteMessage(queueUrl, receiptHandle, arg_0 -> ((SqsClient)this.sqsSyncClient).deleteMessage(arg_0));
    }

    @Override
    public ChangeMessageVisibilityResponse changeVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        return this.changeVisibility(queueUrl, receiptHandle, visibilityTimeout, arg_0 -> ((SqsClient)this.sqsSyncClient).changeMessageVisibility(arg_0));
    }
}

