/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.client;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.awsutils.common.util.Utils;
import org.awsutils.sqs.client.SnsService;
import org.awsutils.sqs.message.SnsMessage;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;

public final class SnsServiceImpl
implements SnsService {
    private final SnsAsyncClient snsAsyncClient;
    private static final String STRING_DATA_TYPE = "String";

    public SnsServiceImpl(SnsAsyncClient snsAsyncClient) {
        this.snsAsyncClient = snsAsyncClient;
    }

    @Override
    public <T> CompletableFuture<PublishResponse> publishMessage(SnsMessage<T> snsMessage, String topicArn, Map<String, String> attributes) {
        String message = Utils.constructJson(snsMessage);
        PublishRequest.Builder publishRequest = PublishRequest.builder().message(message).topicArn(topicArn);
        HashMap<String, MessageAttributeValue> messageAttributesMap = new HashMap<String, MessageAttributeValue>();
        if (StringUtils.hasLength((String)snsMessage.getTransactionId())) {
            messageAttributesMap.put("transactionId", (MessageAttributeValue)MessageAttributeValue.builder().dataType(STRING_DATA_TYPE).stringValue(snsMessage.getTransactionId()).build());
            messageAttributesMap.put("messageType", (MessageAttributeValue)MessageAttributeValue.builder().dataType(STRING_DATA_TYPE).stringValue(snsMessage.getMessageType()).build());
        }
        if (!CollectionUtils.isEmpty(attributes)) {
            messageAttributesMap.putAll(attributes.entrySet().stream().map(entry -> Tuple.of((Object)((String)entry.getKey()), (Object)MessageAttributeValue.builder().stringValue((String)entry.getValue()).dataType(STRING_DATA_TYPE))).collect(Collectors.toMap(Tuple2::_1, tuple -> (MessageAttributeValue)((MessageAttributeValue.Builder)tuple._2()).build())));
        }
        if (!CollectionUtils.isEmpty(messageAttributesMap)) {
            publishRequest.messageAttributes(messageAttributesMap);
        }
        return this.snsAsyncClient.publish((PublishRequest)publishRequest.build());
    }
}

