/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.client;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.awsutils.common.exceptions.UtilsException;
import org.awsutils.sqs.client.AbstractSqsMessageClient;
import org.awsutils.sqs.client.AsyncSqsMessageClient;
import org.awsutils.sqs.message.SqsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public final class AsyncSqsMessageClientImpl
extends AbstractSqsMessageClient<CompletableFuture<SendMessageResponse>, CompletableFuture<SendMessageBatchResponse>, CompletableFuture<DeleteMessageResponse>, CompletableFuture<ChangeMessageVisibilityResponse>>
implements AsyncSqsMessageClient {
    private static final Logger log = LoggerFactory.getLogger(AsyncSqsMessageClientImpl.class);
    private final SqsAsyncClient sqsAsyncClient;

    public AsyncSqsMessageClientImpl(SqsAsyncClient sqsAsyncClient) {
        this.sqsAsyncClient = sqsAsyncClient;
    }

    @Override
    protected String queueUrl(String queueName) {
        try {
            GetQueueUrlRequest queueUrlRequest = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).build();
            CompletableFuture queueUrlResponseFut = this.sqsAsyncClient.getQueueUrl(queueUrlRequest);
            GetQueueUrlResponse queueUrlResponse = (GetQueueUrlResponse)queueUrlResponseFut.get();
            return queueUrlResponse.queueUrl();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UtilsException("UNKNOWN_ERROR", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("Exception while getting queueUrl [ " + queueName + "]: " + e, e.getCause());
            throw new UtilsException("UNKNOWN_ERROR", MessageFormat.format("Exception while getting queueUrl [ {0}]: ", queueName), e.getCause());
        }
    }

    @Override
    public <T> CompletableFuture<SendMessageResponse> sendMessage(SqsMessage<T> sqsMessage, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap) {
        return this.sqsAsyncClient.sendMessage((SendMessageRequest)this.getSendMessageRequestBuilder(sqsMessage, queueName, delayInSeconds, messageAttMap).build()).thenApplyAsync(response -> this.handleSqsResponse(sqsMessage, queueName, delayInSeconds, (SendMessageResponse)response));
    }

    @Override
    public <T> CompletableFuture<SendMessageResponse> sendMessage(T sqsMessage, String messageType, String transactionId, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap) {
        return this.sqsAsyncClient.sendMessage((SendMessageRequest)this.getSendMessageRequestBuilder(sqsMessage, messageType, transactionId, queueName, delayInSeconds, messageAttMap).build()).thenApplyAsync(response -> this.handleSqsResponse(sqsMessage, messageType, queueName, delayInSeconds, (SendMessageResponse)response));
    }

    @Override
    public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<T> sqsMessages, String messageType, String transactionId, String queueName, Integer delayInSeconds, Map<String, String> attMap) {
        return this.sendMessage(sqsMessages, messageType, transactionId, queueName, delayInSeconds, attMap, arg_0 -> ((SqsAsyncClient)this.sqsAsyncClient).sendMessageBatch(arg_0));
    }

    @Override
    public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<SqsMessage<T>> sqsMessages, String queueName, Integer delayInSeconds, Map<String, String> attMap) {
        return this.validateAndSendMessage(sqsMessages, () -> this.sendMessage(sqsMessages, queueName, delayInSeconds, attMap, arg_0 -> ((SqsAsyncClient)this.sqsAsyncClient).sendMessageBatch(arg_0)));
    }

    @Override
    public CompletableFuture<DeleteMessageResponse> deleteMessage(String queueUrl, String receiptHandle) {
        return this.deleteMessage(queueUrl, receiptHandle, arg_0 -> ((SqsAsyncClient)this.sqsAsyncClient).deleteMessage(arg_0));
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityResponse> changeVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        return this.changeVisibility(queueUrl, receiptHandle, visibilityTimeout, arg_0 -> ((SqsAsyncClient)this.sqsAsyncClient).changeMessageVisibility(arg_0));
    }
}

