/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.client;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.awsutils.common.exceptions.UtilsException;
import org.awsutils.common.util.Utils;
import org.awsutils.sqs.client.SqsMessageClient;
import org.awsutils.sqs.message.AbstractAwsMessage;
import org.awsutils.sqs.message.SqsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public class SqsMessageClientImpl
implements SqsMessageClient {
    private static final Logger log = LoggerFactory.getLogger(SqsMessageClientImpl.class);
    private final SqsAsyncClient sqsAsyncClient;
    private final ConcurrentHashMap<String, String> queueUrlMap = new ConcurrentHashMap();

    public SqsMessageClientImpl(SqsAsyncClient sqsAsyncClient) {
        this.sqsAsyncClient = sqsAsyncClient;
    }

    @Override
    public <T> CompletableFuture<SendMessageResponse> sendMessage(T sqsMessage, String messageType, String transactionId, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap) {
        String finalMessage = sqsMessage instanceof String ? (String)sqsMessage : Utils.constructJson(sqsMessage);
        String queueUrl = this.getQueueUrl(queueName);
        SendMessageRequest.Builder sendMessageRequestBuilder = SendMessageRequest.builder().messageBody(finalMessage).delaySeconds(delayInSeconds).queueUrl(queueUrl);
        HashMap<String, String> finalMessageAttributes = !CollectionUtils.isEmpty(messageAttMap) ? new HashMap<String, String>(messageAttMap) : new HashMap();
        finalMessageAttributes.put("sqsMessageWrapperPresent", "false");
        sendMessageRequestBuilder.messageAttributes(this.getSqsMessageAttributeValues(messageType, transactionId, this.getSqsMessageAttributes(finalMessageAttributes)));
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("Sending message to SQS [{0}]: {1}", queueUrl, sqsMessage));
        }
        return this.sqsAsyncClient.sendMessage((SendMessageRequest)sendMessageRequestBuilder.build()).thenApplyAsync(response -> this.handleSqsResponse(sqsMessage, messageType, queueName, delayInSeconds, (SendMessageResponse)response));
    }

    @Override
    public <T> CompletableFuture<SendMessageResponse> sendMessage(SqsMessage<T> sqsMessage, String queueName, Integer delayInSeconds, Map<String, String> messageAttMap) {
        String message = Utils.constructJson(sqsMessage);
        String queueUrl = this.getQueueUrl(queueName);
        SendMessageRequest.Builder sendMessageRequestBuilder = SendMessageRequest.builder().messageBody(message).delaySeconds(delayInSeconds).queueUrl(queueUrl);
        HashMap<String, String> finalMessageAttributes = !CollectionUtils.isEmpty(messageAttMap) ? new HashMap<String, String>(messageAttMap) : new HashMap();
        finalMessageAttributes.put("sqsMessageWrapperPresent", "true");
        sendMessageRequestBuilder.messageAttributes(this.getSqsMessageAttributeValues(sqsMessage, this.getSqsMessageAttributes(finalMessageAttributes)));
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("Sending message to SQS [{0}]: {1}", queueUrl, sqsMessage));
        }
        return this.sqsAsyncClient.sendMessage((SendMessageRequest)sendMessageRequestBuilder.build()).thenApplyAsync(response -> this.handleSqsResponse(sqsMessage, queueName, delayInSeconds, (SendMessageResponse)response));
    }

    private static <T> Map<String, String> constructFinalMessageAttributeMap(SqsMessage<T> sqsMessage, Map<String, String> messageAttMap) {
        HashMap<String, String> finalMessageAttributes = !CollectionUtils.isEmpty(messageAttMap) ? new HashMap<String, String>(messageAttMap) : new HashMap();
        finalMessageAttributes.put("sqsMessageWrapperPresent", "true");
        return finalMessageAttributes;
    }

    private static <T> Map<String, String> constructFinalMessageAttributeMap(String transactionId, String messageType, Map<String, String> messageAttMap) {
        HashMap<String, String> finalMessageAttributes = !CollectionUtils.isEmpty(messageAttMap) ? new HashMap<String, String>(messageAttMap) : new HashMap();
        finalMessageAttributes.put("sqsMessageWrapperPresent", "false");
        return finalMessageAttributes;
    }

    @Override
    public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<T> sqsMessages, String messageType, String transactionId, String queueName, Integer delayInSeconds, Map<String, String> attMap) {
        if (!CollectionUtils.isEmpty(sqsMessages) || sqsMessages.size() <= 10) {
            Map<String, MessageAttributeValue> attributeValueMap = this.getSqsMessageAttributes(SqsMessageClientImpl.constructFinalMessageAttributeMap(transactionId, messageType, attMap));
            String queueUrl = this.getQueueUrl(queueName);
            SendMessageBatchRequest request = (SendMessageBatchRequest)SendMessageBatchRequest.builder().entries((Collection)sqsMessages.stream().map(sqsMessage -> (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(StringUtils.hasLength((String)transactionId) ? transactionId : UUID.randomUUID().toString()).messageBody(Utils.constructJson((Object)sqsMessage)).delaySeconds(delayInSeconds).messageAttributes(this.getSqsMessageAttributeValues(messageType, transactionId, attributeValueMap)).build()).collect(Collectors.toList())).queueUrl(queueUrl).build();
            if (log.isDebugEnabled()) {
                log.debug(MessageFormat.format("Sending messages to SQS[{0}] : {1}", queueUrl, sqsMessages));
            }
            return this.sqsAsyncClient.sendMessageBatch(request);
        }
        log.error(CollectionUtils.isEmpty(sqsMessages) ? "At least one message needs to be sent" : "Maximum number of messages supported is 10");
        throw new IllegalArgumentException(CollectionUtils.isEmpty(sqsMessages) ? "At least one message needs to be sent" : "Maximum number of messages supported is 10");
    }

    @Override
    public <T> CompletableFuture<SendMessageBatchResponse> sendMessage(List<SqsMessage<T>> sqsMessages, String queueName, Integer delayInSeconds, Map<String, String> attMap) {
        if (!CollectionUtils.isEmpty(sqsMessages) || sqsMessages.size() <= 10) {
            Map<String, MessageAttributeValue> attributeValueMap = this.getSqsMessageAttributes(SqsMessageClientImpl.constructFinalMessageAttributeMap(sqsMessages.get(0), attMap));
            String queueUrl = this.getQueueUrl(queueName);
            Set uniqueTransactionIds = sqsMessages.stream().filter(sqsMessage -> !StringUtils.isEmpty((Object)sqsMessage.getTransactionId())).map(AbstractAwsMessage::getTransactionId).collect(Collectors.toSet());
            boolean areTransactionIdsUnique = !CollectionUtils.isEmpty(uniqueTransactionIds) && uniqueTransactionIds.size() == sqsMessages.size();
            SendMessageBatchRequest request = (SendMessageBatchRequest)SendMessageBatchRequest.builder().entries((Collection)sqsMessages.stream().map(sqsMessage -> (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(areTransactionIdsUnique ? sqsMessage.getTransactionId() : UUID.randomUUID().toString()).messageBody(Utils.constructJson((Object)sqsMessage)).delaySeconds(delayInSeconds).messageAttributes(this.getSqsMessageAttributeValues((SqsMessage)sqsMessage, attributeValueMap)).build()).collect(Collectors.toList())).queueUrl(queueUrl).build();
            if (log.isDebugEnabled()) {
                log.debug(MessageFormat.format("Sending messages to SQS[{0}] : {1}", queueUrl, sqsMessages));
            }
            return this.sqsAsyncClient.sendMessageBatch(request);
        }
        log.error(CollectionUtils.isEmpty(sqsMessages) ? "At least one message needs to be sent" : "Maximum number of messages supported is 10");
        throw new IllegalArgumentException(CollectionUtils.isEmpty(sqsMessages) ? "At least one message needs to be sent" : "Maximum number of messages supported is 10");
    }

    @Override
    public String getQueueUrl(String queueName) {
        return this.queueUrlMap.computeIfAbsent(queueName, s -> this.queueUrl(queueName));
    }

    @Override
    public CompletableFuture<DeleteMessageResponse> deleteMessage(String queueUrl, String receiptHandle) {
        DeleteMessageRequest deleteMessageRequest = (DeleteMessageRequest)DeleteMessageRequest.builder().queueUrl(queueUrl).receiptHandle(receiptHandle).build();
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Deleting message  from Queue: {0} with receiptHandle: {1}", queueUrl, receiptHandle));
        }
        return this.sqsAsyncClient.deleteMessage(deleteMessageRequest);
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityResponse> changeVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        ChangeMessageVisibilityRequest request = (ChangeMessageVisibilityRequest)ChangeMessageVisibilityRequest.builder().queueUrl(queueUrl).receiptHandle(receiptHandle).visibilityTimeout(visibilityTimeout).build();
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Changing visibility of [{0}] from queue: {1}", receiptHandle, queueUrl));
        }
        return this.sqsAsyncClient.changeMessageVisibility(request);
    }

    private Map<String, MessageAttributeValue> getSqsMessageAttributes(Map<String, String> attMap) {
        return !CollectionUtils.isEmpty(attMap) ? ImmutableMap.copyOf(attMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, b -> (MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue((String)b.getValue()).build()))) : Collections.emptyMap();
    }

    private <T> Map<String, MessageAttributeValue> getSqsMessageAttributeValues(SqsMessage<T> sqsMessage, Map<String, MessageAttributeValue> attributeValueMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(attributeValueMap);
        if (!StringUtils.isEmpty((Object)sqsMessage.getTransactionId())) {
            builder.put((Object)"transactionId", (Object)((MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(sqsMessage.getTransactionId()).build()));
        }
        builder.put((Object)"messageType", (Object)((MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(sqsMessage.getMessageType()).build()));
        return builder.build();
    }

    private <T> Map<String, MessageAttributeValue> getSqsMessageAttributeValues(String messageType, String transactionId, Map<String, MessageAttributeValue> attributeValueMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(attributeValueMap);
        if (!StringUtils.isEmpty((Object)transactionId)) {
            builder.put((Object)"transactionId", (Object)((MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(transactionId).build()));
        }
        builder.put((Object)"messageType", (Object)((MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(messageType).build()));
        return builder.build();
    }

    private String queueUrl(String queueName) {
        try {
            GetQueueUrlRequest queueUrlRequest = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).build();
            CompletableFuture queueUrlResponseFut = this.sqsAsyncClient.getQueueUrl(queueUrlRequest);
            GetQueueUrlResponse queueUrlResponse = (GetQueueUrlResponse)queueUrlResponseFut.get();
            return queueUrlResponse.queueUrl();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UtilsException("UNKNOWN_ERROR", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("Exception while getting queueUrl [ " + queueName + "]: " + e, e.getCause());
            throw new UtilsException("UNKNOWN_ERROR", MessageFormat.format("Exception while getting queueUrl [ {0}]: ", queueName), e.getCause());
        }
    }

    private <T> SendMessageResponse handleSqsResponse(SqsMessage<T> sqsMessage, String queueName, Integer delayInSeconds, SendMessageResponse response) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Sent message to {0}, message type: {1} w/ delay {2}", queueName, sqsMessage.getMessageType(), delayInSeconds));
        }
        return response;
    }

    private <T> SendMessageResponse handleSqsResponse(T sqsMessage, String messageType, String queueName, Integer delayInSeconds, SendMessageResponse response) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Sent message to {0}, message type: {1} w/ delay {2}", queueName, messageType, delayInSeconds));
        }
        return response;
    }
}

