/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.config;

import jakarta.annotation.PostConstruct;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.awsutils.common.ratelimiter.RateLimiterFactory;
import org.awsutils.common.util.ApplicationContextUtils;
import org.awsutils.common.util.Utils;
import org.awsutils.sqs.config.RateLimiterFactoryImpl;
import org.awsutils.sqs.config.RateLimiterReloader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class RateLimiterConfig {
    private final ApplicationContext applicationContext;
    private final Environment environment;

    public RateLimiterConfig(ApplicationContext applicationContext, Environment environment) {
        this.applicationContext = applicationContext;
        this.environment = environment;
    }

    @Bean
    public RateLimiterFactory rateLimiterFactory() {
        return RateLimiterFactoryImpl.INSTANCE;
    }

    @Bean
    public RateLimiterReloader rateLimiterReloader() {
        return new RateLimiterReloader();
    }

    @PostConstruct
    public void postConstruct() throws InvocationTargetException, IllegalAccessException {
        Method method = Utils.getMethod(ApplicationContextUtils.class, (String)"init", (Class[])new Class[]{ApplicationContext.class, Environment.class});
        method.invoke(null, this.applicationContext, this.environment);
    }
}

