/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.autoconfigure;

import jakarta.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="org.awsutils.aws.sqs.listener")
public class SqsMessageListenerProperties {
    private static final Logger log = LoggerFactory.getLogger(SqsMessageListenerProperties.class);
    private int threadPoolSize;
    private String rateLimiterName;
    private String maximumNumberOfMessagesKey;
    private String messageHandlerRateLimiterName;
    private String statusProperty;
    private int maxMessageProcessorQueueSize = 500;
    private String numberOfListenersProperty;
    private String queueUrl;
    @NotNull(message="org.awsutils.aws.sqs.listener.{name}.scheduleRunIntervalKey")
    private @NotNull(message="org.awsutils.aws.sqs.listener.{name}.scheduleRunIntervalKey") String scheduleRunIntervalKey;
    private String listenerName;
    private Integer waitTimeInSeconds;

    public SqsMessageListenerProperties() {
        log.info("Constructing SqsMessageListenerProperties");
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setRateLimiterName(String rateLimiterName) {
        this.rateLimiterName = rateLimiterName;
    }

    public void setListenerName(String listenerName) {
        this.listenerName = listenerName;
    }

    public void setMaximumNumberOfMessagesKey(String maximumNumberOfMessagesKey) {
        this.maximumNumberOfMessagesKey = maximumNumberOfMessagesKey;
    }

    public void setScheduleRunIntervalKey(String scheduleRunIntervalKey) {
        this.scheduleRunIntervalKey = scheduleRunIntervalKey;
    }

    public void setMessageHandlerRateLimiterName(String messageHandlerRateLimiterName) {
        this.messageHandlerRateLimiterName = messageHandlerRateLimiterName;
    }

    public void setStatusProperty(String statusProperty) {
        this.statusProperty = statusProperty;
    }

    public void setMaxMessageProcessorQueueSize(int maxMessageProcessorQueueSize) {
        this.maxMessageProcessorQueueSize = maxMessageProcessorQueueSize;
    }

    public void setWaitTimeInSeconds(Integer waitTimeInSeconds) {
        this.waitTimeInSeconds = waitTimeInSeconds;
    }

    public void setNumberOfListenersProperty(String numberOfListenersProperty) {
        this.numberOfListenersProperty = numberOfListenersProperty;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String toString() {
        return "SqsMessageListenerProperties{threadPoolSize=" + this.threadPoolSize + ", rateLimiterName='" + this.rateLimiterName + "', maximumNumberOfMessagesKey='" + this.maximumNumberOfMessagesKey + "', messageHandlerRateLimiterName='" + this.messageHandlerRateLimiterName + "', statusProperty='" + this.statusProperty + "', maxMessageProcessorQueueSize=" + this.maxMessageProcessorQueueSize + ", numberOfListeners=" + this.numberOfListenersProperty + ", scheduleRunIntervalKey='" + this.scheduleRunIntervalKey + "', listenerName='" + this.listenerName + "', waitTimeInSeconds=" + this.waitTimeInSeconds + "}";
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public String getRateLimiterName() {
        return this.rateLimiterName;
    }

    public String getMaximumNumberOfMessagesKey() {
        return this.maximumNumberOfMessagesKey;
    }

    public String getMessageHandlerRateLimiterName() {
        return this.messageHandlerRateLimiterName;
    }

    public String getStatusProperty() {
        return this.statusProperty;
    }

    public int getMaxMessageProcessorQueueSize() {
        return this.maxMessageProcessorQueueSize;
    }

    public String getNumberOfListenersProperty() {
        return this.numberOfListenersProperty;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public String getScheduleRunIntervalKey() {
        return this.scheduleRunIntervalKey;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public Integer getWaitTimeInSeconds() {
        return this.waitTimeInSeconds;
    }
}

