/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.autoconfigure;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="org.awsutils.aws.sqs.common")
public class SqsCommonProperties {
    private boolean useCommonThreadPool;
    private int threadPoolSize = 25;
    private int threadPoolCoreSize = 25;
    private int taskExecutorThreadPoolSize = 5;
    private int maxThreadPoolQueueSize = 1000;

    public boolean isUseCommonThreadPool() {
        return this.useCommonThreadPool;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getThreadPoolCoreSize() {
        return this.threadPoolCoreSize;
    }

    public int getTaskExecutorThreadPoolSize() {
        return this.taskExecutorThreadPoolSize;
    }

    public int getMaxThreadPoolQueueSize() {
        return this.maxThreadPoolQueueSize;
    }

    public void setUseCommonThreadPool(boolean useCommonThreadPool) {
        this.useCommonThreadPool = useCommonThreadPool;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setThreadPoolCoreSize(int threadPoolCoreSize) {
        this.threadPoolCoreSize = threadPoolCoreSize;
    }

    public void setTaskExecutorThreadPoolSize(int taskExecutorThreadPoolSize) {
        this.taskExecutorThreadPoolSize = taskExecutorThreadPoolSize;
    }

    public void setMaxThreadPoolQueueSize(int maxThreadPoolQueueSize) {
        this.maxThreadPoolQueueSize = maxThreadPoolQueueSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqsCommonProperties)) {
            return false;
        }
        SqsCommonProperties other = (SqsCommonProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseCommonThreadPool() != other.isUseCommonThreadPool()) {
            return false;
        }
        if (this.getThreadPoolSize() != other.getThreadPoolSize()) {
            return false;
        }
        if (this.getThreadPoolCoreSize() != other.getThreadPoolCoreSize()) {
            return false;
        }
        if (this.getTaskExecutorThreadPoolSize() != other.getTaskExecutorThreadPoolSize()) {
            return false;
        }
        return this.getMaxThreadPoolQueueSize() == other.getMaxThreadPoolQueueSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqsCommonProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseCommonThreadPool() ? 79 : 97);
        result = result * 59 + this.getThreadPoolSize();
        result = result * 59 + this.getThreadPoolCoreSize();
        result = result * 59 + this.getTaskExecutorThreadPoolSize();
        result = result * 59 + this.getMaxThreadPoolQueueSize();
        return result;
    }

    public String toString() {
        return "SqsCommonProperties(useCommonThreadPool=" + this.isUseCommonThreadPool() + ", threadPoolSize=" + this.getThreadPoolSize() + ", threadPoolCoreSize=" + this.getThreadPoolCoreSize() + ", taskExecutorThreadPoolSize=" + this.getTaskExecutorThreadPoolSize() + ", maxThreadPoolQueueSize=" + this.getMaxThreadPoolQueueSize() + ")";
    }
}

