/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.autoconfigure;

import io.vavr.Tuple2;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.awsutils.common.util.ApplicationContextUtils;
import org.awsutils.common.util.Utils;
import org.awsutils.sqs.client.AsyncSqsMessageClient;
import org.awsutils.sqs.client.AsyncSqsMessageClientImpl;
import org.awsutils.sqs.client.SnsService;
import org.awsutils.sqs.client.SnsServiceImpl;
import org.awsutils.sqs.client.SyncSqsMessageClient;
import org.awsutils.sqs.client.SyncSqsMessageClientImpl;
import org.awsutils.sqs.handler.MessageHandlerFactory;
import org.awsutils.sqs.handler.MessageHandlerFactoryImpl;
import org.awsutils.sqs.handler.impl.AbstractSqsMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsClient;

@Configuration
public class MessageHandlerFactoryConfig {
    private static final Logger log = LoggerFactory.getLogger(MessageHandlerFactoryConfig.class);
    private final Map<String, Tuple2<Constructor<AbstractSqsMessageHandler>, Method>> handlerMapping;
    private final SqsAsyncClient sqsAsyncClient;
    private final SnsAsyncClient snsAsyncClient;
    private final SqsClient sqsSyncClient;
    private final SnsClient snsSyncClient;
    private final ApplicationContext applicationContext;
    private final Environment environment;
    private final Map<String, Method> methodHandlerMapping;

    public MessageHandlerFactoryConfig(SqsAsyncClient sqsAsyncClient, SnsAsyncClient snsAsyncClient, ApplicationContext applicationContext, SqsClient sqsSyncClient, SnsClient snsSyncClient, Environment environment) throws InvocationTargetException, IllegalAccessException {
        this.sqsSyncClient = sqsSyncClient;
        this.snsSyncClient = snsSyncClient;
        Method method = Utils.getMethod(ApplicationContextUtils.class, (String)"init", (Class[])new Class[]{ApplicationContext.class, Environment.class});
        method.invoke(null, applicationContext, environment);
        this.handlerMapping = (Map)applicationContext.getBean("sqsMessageHandlerMapping");
        this.methodHandlerMapping = (Map)applicationContext.getBean("sqsMethodLevelMessageHandlerMapping");
        this.sqsAsyncClient = sqsAsyncClient;
        this.snsAsyncClient = snsAsyncClient;
        this.applicationContext = applicationContext;
        this.environment = environment;
    }

    @Bean
    public MessageHandlerFactory messageHandlerFactory() {
        return new MessageHandlerFactoryImpl(this.handlerMapping, this.methodHandlerMapping, this.applicationContext);
    }

    @Bean
    public AsyncSqsMessageClient asyncSqsMessageClientV2() {
        return new AsyncSqsMessageClientImpl(this.sqsAsyncClient);
    }

    @Bean
    public SyncSqsMessageClient syncSqsMessageClient() {
        return new SyncSqsMessageClientImpl(this.sqsSyncClient);
    }

    @Bean
    public SnsService snsService() {
        return new SnsServiceImpl(this.snsAsyncClient);
    }
}

