/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.autoconfigure;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.awsutils.common.config.AwsEnvironmentProperties;
import org.awsutils.common.util.LimitedQueue;
import org.awsutils.sqs.autoconfigure.SqsCommonProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;

@Configuration
public class SqsConfig {
    private static final Logger log = LoggerFactory.getLogger(SqsConfig.class);

    @Bean(value={"snsAsyncClientBuilder"})
    @ConditionalOnBean(value={SdkAsyncHttpClient.class})
    public SnsAsyncClientBuilder snsAsyncClientBuilder(SdkAsyncHttpClient selectedSdkAsyncHttpClient, AwsEnvironmentProperties sqsProperties) throws URISyntaxException {
        SnsAsyncClientBuilder builder = (SnsAsyncClientBuilder)((SnsAsyncClientBuilder)SnsAsyncClient.builder().region(Region.of((String)sqsProperties.getRegion()))).httpClient(selectedSdkAsyncHttpClient);
        if (sqsProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)sqsProperties.getLocalAwsEndpoint())) {
            return (SnsAsyncClientBuilder)builder.endpointOverride(new URI(sqsProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean(value={"snsAsyncClientBuilder"})
    @ConditionalOnMissingBean(value={SdkAsyncHttpClient.class})
    public SnsAsyncClientBuilder snsAsyncClientBuilder(AwsEnvironmentProperties sqsProperties) throws URISyntaxException {
        SnsAsyncClientBuilder builder = (SnsAsyncClientBuilder)SnsAsyncClient.builder().region(Region.of((String)sqsProperties.getRegion()));
        if (sqsProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)sqsProperties.getLocalAwsEndpoint())) {
            return (SnsAsyncClientBuilder)builder.endpointOverride(new URI(sqsProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean(value={"sqsAsyncClientBuilder"})
    @ConditionalOnBean(value={SdkAsyncHttpClient.class})
    public SqsAsyncClientBuilder sqsAsyncClientBuilder(SdkAsyncHttpClient selectedSdkAsyncHttpClient, AwsEnvironmentProperties sqsProperties) throws URISyntaxException {
        SqsAsyncClientBuilder builder = (SqsAsyncClientBuilder)((SqsAsyncClientBuilder)SqsAsyncClient.builder().region(Region.of((String)sqsProperties.getRegion()))).httpClient(selectedSdkAsyncHttpClient);
        if (sqsProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)sqsProperties.getLocalAwsEndpoint())) {
            return (SqsAsyncClientBuilder)builder.endpointOverride(new URI(sqsProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean(value={"sqsAsyncClientBuilder"})
    @ConditionalOnMissingBean(value={SdkAsyncHttpClient.class})
    public SqsAsyncClientBuilder sqsAsyncClientBuilder(AwsEnvironmentProperties sqsProperties) throws URISyntaxException {
        SqsAsyncClientBuilder builder = (SqsAsyncClientBuilder)SqsAsyncClient.builder().region(Region.of((String)sqsProperties.getRegion()));
        if (sqsProperties.isLocalAwsMode() && !StringUtils.isEmpty((CharSequence)sqsProperties.getLocalAwsEndpoint())) {
            return (SqsAsyncClientBuilder)builder.endpointOverride(new URI(sqsProperties.getLocalAwsEndpoint()));
        }
        return builder;
    }

    @Bean
    @ConditionalOnBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public SnsAsyncClient snsAsyncClient(SnsAsyncClientBuilder snsAsyncClientBuilder, AwsCredentialsProvider staticCredentialsProvider) {
        return (SnsAsyncClient)((SnsAsyncClientBuilder)snsAsyncClientBuilder.credentialsProvider(staticCredentialsProvider)).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public SnsAsyncClient snsAsyncClientEnv(SnsAsyncClientBuilder snsAsyncClientBuilder) {
        return (SnsAsyncClient)snsAsyncClientBuilder.build();
    }

    @Bean
    @ConditionalOnBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public SqsAsyncClient sqsAsyncClient(AwsCredentialsProvider staticCredentialsProvider, SqsAsyncClientBuilder sqsAsyncClientBuilder) {
        return (SqsAsyncClient)((SqsAsyncClientBuilder)sqsAsyncClientBuilder.credentialsProvider(staticCredentialsProvider)).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.awsutils.aws", value={"region"})
    public SqsAsyncClient sqsAsyncClientEnv(SqsAsyncClientBuilder sqsAsyncClientBuilder) {
        return (SqsAsyncClient)sqsAsyncClientBuilder.build();
    }

    @Bean(name={"messagePollingIntervalPropertyPropertyFunc"})
    @ConditionalOnMissingBean(name={"messagePollingIntervalPropertyFF4jFunc"})
    public SqsPropertyFunc1<String, Integer> messagePollingIntervalPropertyPropertyFunc(Environment environment) {
        return propertyName -> {
            try {
                return Integer.parseInt(Objects.requireNonNull(environment.getProperty(propertyName)));
            }
            catch (RuntimeException e) {
                log.error(MessageFormat.format("Error while getting property: {0}. Please make sure the property is present in application.yaml/application.properties/CCS", propertyName));
                throw e;
            }
        };
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnProperty(prefix="org.awsutils.aws.sqs.common", name={"threadPoolSize"})
    public CommonExecutorService commonExecutorService(SqsCommonProperties sqsCommonProperties) {
        return new CommonExecutorService(this.getThreadPoolExecutor(sqsCommonProperties.getThreadPoolCoreSize(), sqsCommonProperties.getThreadPoolSize(), sqsCommonProperties.getMaxThreadPoolQueueSize()));
    }

    @Bean
    @ConditionalOnMissingBean(value={TaskScheduler.class})
    public TaskScheduler taskScheduler(SqsCommonProperties sqsCommonProperties) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(sqsCommonProperties.getTaskExecutorThreadPoolSize());
        return scheduler;
    }

    private ThreadPoolExecutor getThreadPoolExecutor(int coreSize, int maxPoolSize, int maxPoolQueueSize) {
        return this.getThreadPoolExecutor(coreSize, maxPoolSize, maxPoolQueueSize, 0L, TimeUnit.MILLISECONDS);
    }

    private ThreadPoolExecutor getThreadPoolExecutor(int coreSize, int maxPoolSize, int maxPoolQueueSize, long keepAliveTime, TimeUnit keepAliveTimeUnit) {
        LimitedQueue runnables = new LimitedQueue(maxPoolQueueSize);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(coreSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, (BlockingQueue<Runnable>)runnables, (RejectedExecutionHandler)new LimitedQueue.LimitedQueueRejectedExecutionPolicy());
        runnables.setThreadPoolExecutor(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static interface SqsPropertyFunc1<T, R>
    extends Function<T, R> {
    }

    public record CommonExecutorService(ExecutorService executorService) {
        void shutdown() {
            this.executorService.shutdown();
        }
    }
}

