/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.autoconfigure;

import io.vavr.Tuple;
import io.vavr.Tuple4;
import java.lang.reflect.Proxy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.function.Function;
import org.awsutils.sqs.autoconfigure.SqsListenerScheduleConfig;
import org.awsutils.sqs.listener.SqsMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
@ConditionalOnBean(value={TaskScheduler.class})
public class TaskRegistrarConfig {
    private final TaskScheduler taskScheduler;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskRegistrarConfig.class);

    public TaskRegistrarConfig(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    @Bean
    public SqsListenerScheduleConfig schedulingConfigurer() {
        LOGGER.info("Instantiating SqsListenerScheduleConfig");
        SqsListenerScheduleConfigImpl sqsListenerScheduleConfig = new SqsListenerScheduleConfigImpl(this.taskScheduler);
        return (SqsListenerScheduleConfig)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{SqsListenerScheduleConfig.class}, (proxy, method, args) -> method.invoke((Object)sqsListenerScheduleConfig, args));
    }

    private static class SqsListenerScheduleConfigImpl
    implements SqsListenerScheduleConfig {
        private final TaskScheduler taskScheduler;
        private final List<Tuple4<SqsMessageListener, String, String, Function<String, Integer>>> listenerList = new ArrayList<Tuple4<SqsMessageListener, String, String, Function<String, Integer>>>();

        SqsListenerScheduleConfigImpl(TaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
        }

        @Override
        public void addListener(SqsMessageListener sqsMessageListener, String maxMessageKey, String intervalKey, Function<String, Integer> func1) {
            this.listenerList.add((Tuple4<SqsMessageListener, String, String, Function<String, Integer>>)Tuple.of((Object)sqsMessageListener, (Object)maxMessageKey, (Object)intervalKey, func1));
        }

        private Instant getNextRunTimeForPrefSyncUp(TriggerContext triggerContext, String intervalKey, Function<String, Integer> func1) {
            return this.getNextExecutionTime(triggerContext, intervalKey, func1);
        }

        private Instant getNextExecutionTime(TriggerContext triggerContext, String propertyName, Function<String, Integer> func1) {
            GregorianCalendar nextExecutionTime = new GregorianCalendar();
            Date lastActualExecutionTime = triggerContext.lastActualExecutionTime();
            nextExecutionTime.setTime(lastActualExecutionTime != null ? lastActualExecutionTime : new Date());
            ((Calendar)nextExecutionTime).add(14, func1.apply(propertyName));
            return nextExecutionTime.getTime().toInstant();
        }

        public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
            scheduledTaskRegistrar.setTaskScheduler(this.taskScheduler);
            this.listenerList.forEach(tuple -> scheduledTaskRegistrar.addTriggerTask(() -> ((SqsMessageListener)tuple._1()).receive(), triggerContext -> this.getNextRunTimeForPrefSyncUp(triggerContext, (String)tuple._3(), (Function)tuple._4())));
        }
    }
}

