/*
 * Decompiled with CFR 0.152.
 */
package org.awsutils.sqs.autoconfigure;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.awsutils.common.exceptions.UtilsException;
import org.awsutils.common.ratelimiter.RateLimiter;
import org.awsutils.common.util.Utils;
import org.awsutils.sqs.annotations.MessageHandler;
import org.awsutils.sqs.autoconfigure.SqsMessageListenerListProperties;
import org.awsutils.sqs.handler.impl.AbstractSqsMessageHandler;
import org.awsutils.sqs.message.SqsMessage;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SqsMessageHandlerConfig {
    private static final Logger log = LoggerFactory.getLogger(SqsMessageHandlerConfig.class);
    private final SqsMessageListenerListProperties sqsMessageListenerListProperties;
    private final ApplicationContext applicationContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(SqsMessageHandlerConfig.class);

    public SqsMessageHandlerConfig(SqsMessageListenerListProperties sqsMessageListenerListProperties, ApplicationContext applicationContext) {
        this.sqsMessageListenerListProperties = sqsMessageListenerListProperties;
        this.applicationContext = applicationContext;
    }

    @Bean(name={"sqsMessageHandlerMapping"})
    public Map<String, Tuple2<Constructor<AbstractSqsMessageHandler<?>>, Method>> sqsMessageHandlerMapping() {
        Reflections reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)this.sqsMessageListenerListProperties.getHandlerBasePackage(), (ClassLoader[])new ClassLoader[0])));
        Set annotated = reflections.get(Scanners.TypesAnnotated.with(new AnnotatedElement[]{MessageHandler.class}).asClass(new ClassLoader[0]));
        List<Tuple2> tuples = annotated.stream().map(a -> Tuple.of((Object)a.getDeclaredAnnotation(MessageHandler.class).messageType(), (Object)a)).toList();
        Map<String, Tuple2<Constructor<AbstractSqsMessageHandler<?>>, Method>> handlerMapping = tuples.stream().collect(Collectors.toMap(x -> (String)x._1, tuple -> Tuple.of((Object)Utils.getConstructor((Class)((Class)tuple._2()), e -> {
            LOGGER.error("*************** No empty constructor defined in " + tuple._2());
            LOGGER.error("*************** No empty constructor defined in " + tuple._2());
            LOGGER.error("All SQS Message Handlers must have an empty constructor [private/public/protected]");
            throw new UtilsException("MISSING_EMPTY_CONSTRUCTOR", (Throwable)e);
        }, (Class[])new Class[0]), (Object)Utils.getMethod(AbstractSqsMessageHandler.class, (String)"initialize", (Class[])new Class[]{SqsMessage.class, String.class, String.class, Integer.class, Map.class, RateLimiter.class}))));
        handlerMapping.forEach((key, value) -> LOGGER.info(String.format("handlerMapping1: %s + -> %s", key, value)));
        return handlerMapping;
    }

    @Bean(name={"sqsMethodLevelMessageHandlerMapping"})
    public Map<String, Method> sqsMethodLevelMessageHandlerMapping() {
        Reflections reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)this.sqsMessageListenerListProperties.getHandlerBasePackage(), (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{Scanners.MethodsAnnotated}));
        Set annotated = reflections.getMethodsAnnotatedWith(MessageHandler.class).stream().filter(this::isSpringBean).collect(Collectors.toSet());
        List<Tuple2> tuples = annotated.stream().map(a -> Tuple.of((Object)a.getDeclaredAnnotation(MessageHandler.class).messageType(), (Object)a)).toList();
        Map<String, Method> handlerMapping = tuples.stream().collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
        handlerMapping.forEach((key, value) -> LOGGER.info(String.format("handlerMapping1: %s + -> %s", key, value)));
        return handlerMapping;
    }

    private boolean isSpringBean(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            Object[] beanNames = this.applicationContext.getBeanNamesForType(declaringClass);
            return !ArrayUtils.isEmpty((Object[])beanNames);
        }
        catch (Throwable ex) {
            log.error("method level @MessageHandler annotation can only be used in Spring beans.....");
            log.error("method level @MessageHandler annotation can only be used in Spring beans.....");
            return false;
        }
    }
}

