/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.test.feign.feigntest.clientapplication.person.controllers;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.autumnframework.service.api.dtos.Identifiable;
import org.autumnframework.service.test.api.PersonDTO;
import org.autumnframework.service.test.services.PersonService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test/persons"})
public class TestPersonAPIController {
    private final PersonService personService;

    public TestPersonAPIController(PersonService personService) {
        this.personService = personService;
    }

    @PostMapping(value={"/"})
    @ResponseBody
    public PersonDTO create(@RequestBody PersonDTO dto) {
        return (PersonDTO)this.personService.create((Identifiable)dto);
    }

    @GetMapping(value={"/{id}"})
    public Optional<PersonDTO> findById(@PathVariable(value="id") UUID id) {
        return this.personService.findById(id);
    }

    @GetMapping(value={"/ids"})
    public List<PersonDTO> findByIds(@RequestParam(name="id") List<UUID> ids) {
        return this.personService.findByIds(ids);
    }

    @GetMapping(value={"/"})
    public Page<PersonDTO> findAll(Pageable pageable) {
        return this.personService.findAll(pageable);
    }

    @PutMapping(path={"/"})
    @ResponseBody
    public PersonDTO update(@RequestBody PersonDTO dto) {
        return (PersonDTO)this.personService.update((Identifiable)dto);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") UUID id) {
        this.personService.deleteById(id);
    }

    @DeleteMapping(value={"/ids"})
    public void deleteByIds(@RequestParam(name="id") List<UUID> ids) {
        this.personService.deleteByIds(ids);
    }

    @Scheduled(cron="0/10 * * * * *")
    public void schedule() {
        this.personService.findAll((Pageable)PageRequest.of((int)0, (int)10));
    }
}

