/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.test.queue.server.services;

import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import org.autumnframework.service.queue.server.sender.MessageSender;
import org.autumnframework.service.test.api.SomeDTO;
import org.autumnframework.service.test.api.SomeMessage;
import org.autumnframework.service.validation.services.DefaultValidationService;

/**
 * @author Timon Veenstra
 */
@Service
public class TestSenderService extends MessageSender<SomeDTO, SomeMessage> {

    /**
     * @param validationService
     * @param context
     */
    public TestSenderService(DefaultValidationService validationService, ApplicationContext context) {
        super(validationService, context);
    }
}
