/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.test.queue.server.services;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;
import org.autumnframework.service.queue.api.messages.IdentifiableMessage;
import org.autumnframework.service.test.api.PersonDTO;
import org.autumnframework.service.test.api.PersonMessage;
import org.autumnframework.service.test.api.SomeDTO;
import org.autumnframework.service.test.api.SomeMessage;
import org.autumnframework.service.test.queue.server.services.PersonSenderService;
import org.autumnframework.service.test.queue.server.services.TestSenderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class MessageProducerService {
    private static final Logger log = LoggerFactory.getLogger(MessageProducerService.class);
    private final TestSenderService senderService;
    private final PersonSenderService personSenderService;

    public MessageProducerService(TestSenderService senderService, PersonSenderService personSenderService) {
        this.senderService = senderService;
        this.personSenderService = personSenderService;
    }

    @Async
    @Scheduled(fixedRate=1000L)
    public void sendCreate() {
        log.trace("sendCreate");
        this.senderService.sendCreate((IdentifiableMessage)SomeMessage.builder().payload(SomeDTO.builder().id(UUID.randomUUID()).someProperty("CREATE").someDate(LocalDate.of(2020, 1, 1)).someDateTime(LocalDateTime.MAX).build()).build());
        this.personSenderService.sendCreate((IdentifiableMessage)PersonMessage.builder().payload(PersonDTO.builder().firstName("John").lastName("Applebottom").id(UUID.randomUUID()).build()).messageChainId(UUID.randomUUID()).build());
    }

    @Async
    @Scheduled(fixedRate=3000L)
    public void sendUpdate() {
        log.trace("sendUpdate");
        this.senderService.sendUpdate((IdentifiableMessage)SomeMessage.builder().payload(SomeDTO.builder().id(UUID.randomUUID()).someProperty("UPDATE").someDate(LocalDate.of(2020, 1, 1)).someDateTime(LocalDateTime.MAX).build()).build());
    }

    @Async
    @Scheduled(fixedRate=5000L)
    public void sendDelete() {
        log.trace("sendDelete");
        this.senderService.sendDelete((IdentifiableMessage)SomeMessage.builder().payload(SomeDTO.builder().id(UUID.randomUUID()).someProperty("DELETE").someDate(LocalDate.of(2020, 1, 1)).someDateTime(LocalDateTime.MAX).build()).build());
    }
}

